__all__ = [
    "ModelArgs",
    "StandardKVCache",
    "PageManager",
    "load_model",
    "sample",
    "init_dist",
    "setup_seed",
    "apply_tp",
]

# Lazy import
def __getattr__(name: str):
    if name == "ModelArgs":
        from .config import ModelArgs
        return locals()[name]
    if name == "StandardKVCache":
        from .kv_cache import StandardKVCache
        return locals()[name]
    if name == "PageManager":
        from .paging import PageManager
        return locals()[name]
    if name == "load_model":
        from .model_loading import load_model
        return locals()[name]
    if name == "sample":
        from .sampling import sample
        return locals()[name]
    if name in ["init_dist", "apply_tp"]:
        from .tensor_parallel import init_dist, apply_tp
        return locals()[name]
    if name == "setup_seed":
        from .misc import setup_seed
        return locals()[name]
    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")