__all__ = [
    "BaseLMBackend",
    "MTPLMBackend",
    "StandardLMBackend",
]

def __getattr__(name: str):
    if name in ("BaseLMBackend"):
        from .base_backend import BaseLMBackend
        return locals()[name]
    if name == "MTPLMBackend":
        from .mtp_backend import MTPLMBackend
        return locals()[name]
    if name == "StandardLMBackend":
        from .standard_backend import StandardLMBackend
        return locals()[name]
    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")

def __dir__():
    return __all__