__all__ = [
    "standard_model",
    "streamingllm_model",
    "rollingllm_model",
    "eagle_model",
    "snapkv_model",
    "standard_draft_model",
    "streaming_draft_model",
    "MTPTransformer",
]

def __getattr__(name: str):
    if name == "standard_model":
        from .standard_model import Transformer as StandardModel
        return locals()[name]
    if name == "streamingllm_model":
        from .streamingllm_model import Transformer as StreamingLLMModel
        return locals()[name]
    if name == "rollingllm_model":
        from .rollingllm_model import Transformer as RollingLLMModel
        return locals()[name]
    if name == "eagle_model":
        from .eagle_model import Transformer as EagleModel
        return locals()[name]
    if name == "snapkv_model":
        from .snapkv_model import Transformer as SnapKVModel
        return locals()[name]
    if name == "standard_draft_model":
        from .standard_draft_model import Transformer as StandardDraftModel
        return locals()[name]
    if name == "streaming_draft_model":
        from .streaming_draft_model import Transformer as StreamingDraftModel
        return locals()[name]
    if name == "MTPTransformer":
        from .mtp_model import MTPTransformer
        return locals()[name]
    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")

def __dir__():
    return __all__