__all__ = [
    "ModelArgs",
    "LoRAConfig",
    "BaseTransformer",
    "BaseAttention",
    "BaseTransformerBlock",
    "FeedForward",
    "RMSNorm",
    "StandardKVCache",
    "StreamingKVCache",
    "Sampler",
    "GatedLoRALinear",
]

def __getattr__(name: str):
    if name in ("ModelArgs", "LoRAConfig"):
        from .config import ModelArgs, LoRAConfig
        return locals()[name]
    if name in ("BaseTransformer", "BaseAttention", "BaseTransformerBlock", "FeedForward", "RMSNorm"):
        from .model import BaseTransformer, BaseAttention, BaseTransformerBlock, FeedForward, RMSNorm
        return locals()[name]
    if name in ("StandardKVCache", "StreamingKVCache"):
        from .kv_cache import StandardKVCache, StreamingKVCache
        return locals()[name]
    if name in ("Sampler"):
        from .mtp_sampler import Sampler
        return locals()[name]
    if name in ("GatedLoRALinear"):
        from .gated_lora import GatedLoRALinear
        return locals()[name]
    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")

def __dir__():
    return __all__