__all__ = [
    "load_model",
    "PageManager",
    "get_sampling_probs", "sample",
    "dynamically_quantize_per_channel",
    "replace_linear_weight_only_int8_per_channel",
    "WeightOnlyInt8QuantHandler", "WeightOnlyInt8Linear",
    "register_custom_attn_op", "device_sync", "setup_seed",
    "init_dist", "apply_tp", "apply_tp_eagle",
]

def __getattr__(name: str):
    if name in ("ModelArgs", "load_model"):
        from .model_loading import load_model
        return locals()[name]
    if name in ("PageManager"):
        from .paging import PageManager
        return locals()[name]
    if name in ("get_sampling_probs", "sample"):
        from .sampling import get_sampling_probs, sample
        return locals()[name]
    if name in (
        "dynamically_quantize_per_channel",
        "replace_linear_weight_only_int8_per_channel",
        "WeightOnlyInt8QuantHandler",
        "WeightOnlyInt8Linear",
    ):
        from .quantization import (
            dynamically_quantize_per_channel,
            replace_linear_weight_only_int8_per_channel,
            WeightOnlyInt8QuantHandler,
            WeightOnlyInt8Linear,
        )
        return locals()[name]
    if name in ("register_custom_attn_op", "device_sync", "setup_seed"):
        from .misc import register_custom_attn_op, device_sync, setup_seed
        return locals()[name]
    if name in ("init_dist", "apply_tp", "apply_tp_eagle"):
        from .tensor_parallel import init_dist, apply_tp, apply_tp_eagle
        return locals()[name]
    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")

def __dir__():
    return __all__