import torch
import numpy as np
import random

def register_custom_attn_op(name: str, wrapper, device: str = "cuda"):
    torch.library.define(
        name,
        "(Tensor q, Tensor kv_cache) -> Tensor",
    )

    @torch.library.impl(name, device)
    def _impl(q, kv_cache):
        return wrapper.run(q, kv_cache)

    @torch.library.register_fake(name)
    def _abstract(q, kv_cache):
        return torch.empty_like(q)

def device_sync(device):
    if "cuda" in device:
        torch.cuda.synchronize(device)
    elif ("cpu" in device) or ("mps" in device):
        pass
    else:
        print(f"device={device} is not yet suppported")

def setup_seed(seed):
    torch.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    np.random.seed(seed)
    random.seed(seed)
    torch.backends.cudnn.deterministic = True