# import gymnasium as gym
# from gymnasium.wrappers import TimeLimit
from .halfcheetah import HalfCheetah
from .ant import Ant
from .walker2d import Walker2d
from .hopper import Hopper
from .simulations import SimEnv3

def get_env(cfg: dict, seed: int):
    # gym.envs.register(
    #     id='MountainCarContinuous-v2',
    #     entry_point=Continuous_MountainCarEnvV2,
    #     max_episode_steps=cfg.max_episode_steps
    # )

    # if cfg.name == "AcrobotContinuous":
    #     env = AcrobotEnv(seed=seed, continuous_action=True)
    #     env = TimeLimit(env, max_episode_steps=cfg.max_episode_steps)
    #     return env
    # elif cfg.gym:
    #     return gym.make(cfg.name, max_episode_steps=cfg.max_episode_steps)
    # else:
    #     raise NotImplementedError
    if cfg.name == "HalfCheetah":
        env = HalfCheetah(seed=seed)
        return env
    elif cfg.name == "Walker2d":
        return Walker2d(seed=seed)
    elif cfg.name == "Hopper":
        return Hopper(seed=seed)
    elif cfg.name == "Ant":
        return Ant(seed=seed)
    elif cfg.name == "SimEnv3":
        return SimEnv3(seed=seed)
    else:
        raise NotImplementedError
