clear all;
close all;
clc;

K_bin = 1:2:5;
MOV_bin = 2.^(6:2:10);
m = 4;
alpha_copeland = 0.5;

for K = K_bin
for MOV = MOV_bin
disp(['starting K=',num2str(K),' MOV=',num2str(MOV),' m=',num2str(m),'_copeland'])

% m = 2;
% MOV = 2^6;
% K = 1;

t_bin = 4:16;
t2 = 20;
num_exp = 1e5;
mf = factorial(m);
n = 2^t2;

% Assume the profile uses the alphabic order
nPF = ones(mf,1)/mf;
PF = nPF*(n-2*MOV);
PF(1) = PF(1) + MOV;
PF(2) = PF(2) + MOV;
nPF = PF/n;
m1f = mf/m;
phi_bin = asin(sqrt(nPF))/pi;

permutation = perms(m:-1:1);

tic
%% Calculate Pr[correct] for the classical algorithm
p_correct_c = zeros(m, length(t_bin));
for temp = 1:length(t_bin)
    t = t_bin(temp);
    T = 2^t*K;
    samples_c = zeros(mf,num_exp);
    parfor temp_exp = 1:num_exp
        samples_c(:,temp_exp) = mnrnd(T,nPF')';
    end
    
    % Calculate the weights
    WMG_c = zeros(m, m, num_exp);
    for a1 = 1:m-1
        for a2 = a1+1:m
            for temp_ranking = 1:mf
                ranking_temp = permutation(temp_ranking,:);
                if find(ranking_temp == a1) < find(ranking_temp == a2)
                    WMG_c(a1,a2,:) = WMG_c(a1,a2,:) + reshape(samples_c(temp_ranking,:),1,1,num_exp);
                else
                    WMG_c(a2,a1,:) = WMG_c(a2,a1,:) + reshape(samples_c(temp_ranking,:),1,1,num_exp);
                end
            end
        end
    end

    % Calculate the score of each candidate
    scores_c = zeros(m, num_exp);
    for a1 = 1:m-1
        for a2 = a1+1:m
            ties = reshape(WMG_c(a2,a1,:) == WMG_c(a1,a2,:),1,num_exp);
            scores_c(a1,:) = scores_c(a1,:) + alpha_copeland*ties + reshape(WMG_c(a1,a2,:) > WMG_c(a2,a1,:),1,num_exp);
            scores_c(a2,:) = scores_c(a2,:) + alpha_copeland*ties + reshape(WMG_c(a2,a1,:) > WMG_c(a1,a2,:),1,num_exp);
        end
    end
    p_correct_c(:,temp) = sum(cal_prob(scores_c),2)/num_exp;
end
toc
disp('classical finished')


tic
%% Calculate the distribution for the quantum algorithm
p_bin_q = cell(size(t_bin));
est_q = cell(size(t_bin));    % The estimated nPF for any output

% For the quantum algorithm
for temp = 1:length(t_bin)
    t = t_bin(temp);
    T = 2^t;
    temp_p_mat_q = zeros(mf, T);
    est_q{temp} = sin((0:1/T:1-1/T)*pi).^2;
    for temp_vote = 1:mf
        phi = phi_bin(temp_vote);
        b = floor(phi*T);
        delta = phi - b/T;
        l = 0:(T-1);
        ell = mod(b+l,T);
        alpha = 1/T * (1-exp(2*pi*1i*(T*delta-l))) ./ (1-exp(2*pi*1i*(delta-l/T)));
        p = abs(alpha).^2;
        p(ell+1) = p(l+1);
        temp_p_mat_q(temp_vote,:) = cumsum(p);
    end
    p_bin_q{temp} = temp_p_mat_q;
end
toc

%% Calculate the estimated probability to win if K=1 (for quantum)
% We always set the first candidate as the ground truth winner
p_correct_q_1 = zeros(m, length(t_bin));
for temp = 1:length(t_bin)
    temp_p_mat_q = p_bin_q{temp};
    samples_q = zeros(mf, num_exp);
    for temp_vote = 1:mf
        p_q = temp_p_mat_q(temp_vote,:);
        samples_q(temp_vote,:) = mySampling(p_q, num_exp, est_q{temp});
    end

    % Calculate the weights
    WMG_q = zeros(m, m, num_exp);
    for a1 = 1:m-1
        for a2 = a1+1:m
            for temp_ranking = 1:mf
                ranking_temp = permutation(temp_ranking,:);
                if find(ranking_temp == a1) < find(ranking_temp == a2)
                    WMG_q(a1,a2,:) = WMG_q(a1,a2,:) + reshape(samples_q(temp_ranking,:),1,1,num_exp);
                else
                    WMG_q(a2,a1,:) = WMG_q(a2,a1,:) + reshape(samples_q(temp_ranking,:),1,1,num_exp);
                end
            end
        end
    end

    % Calculate the score of each candidate
    scores_q = zeros(m, num_exp);
    for a1 = 1:m-1
        for a2 = a1+1:m
            ties = reshape(WMG_q(a2,a1,:) == WMG_q(a1,a2,:),1,num_exp);
            scores_q(a1,:) = scores_q(a1,:) + alpha_copeland*ties + reshape(WMG_q(a1,a2,:) > WMG_q(a2,a1,:),1,num_exp);
            scores_q(a2,:) = scores_q(a2,:) + alpha_copeland*ties + reshape(WMG_q(a2,a1,:) > WMG_q(a1,a2,:),1,num_exp);
        end
    end

    % Decide the winning probability of each candidate
    % We break ties uniformly
    p_correct_q_1(:,temp) = sum(cal_prob(scores_q),2)/num_exp;
end
toc

%% Calculate Pr[correct] for the defined K value (for quantum)
p_correct_q_k = zeros(m, length(t_bin));
for temp = 1:length(t_bin)
    samples = mySampling2(cumsum(p_correct_q_1(:,temp)), num_exp, K);
    scores = zeros(m,num_exp);
    for tempm = 1:m
        scores(tempm,:) = sum(samples == tempm, 1)';
    end
    p_correct_q_k(:,temp) = sum(cal_prob(scores),2)/num_exp;
end
toc
disp('quantum finished')

% figure,
% subplot(1,2,1)
% plot(t_bin,p_correct_c(1,:),'r')
% hold on;
% plot(t_bin,p_correct_q_1(1,:),'b')
% grid on;
% 
% subplot(1,2,2)
% plot(t_bin,p_correct_c(1,:),'r')
% hold on;
% plot(t_bin,p_correct_q_k(1,:),'b')
% grid on;



save(['K_',num2str(K),'_MOV_',num2str(MOV),'_m_',num2str(m),'_copeland.mat'], 't_bin','p_correct_q_1','p_correct_c','p_correct_q_k')
end
end

