clear all;
close all;
clc;

K_bin = [69, 139];
fontsize = 14;

lim_y = cell(size(K_bin));
lim_y{1} = [0.92,1];
lim_y{2} = [0.98,1];

lim_x = cell(size(K_bin));
lim_x{1} = [19,25.12];
lim_x{2} = [20,26.12];

t_2 = 20;
n = 2^t_2;
t_bin = 13:t_2-1;
t_classical_bin = t_bin;

MOV = 2^10;
GT = n/2-MOV;
phi = asin(sqrt(GT/n))/pi;
p_quantum_bin = zeros(size(t_bin));
p_classic_bin = zeros(size(t_classical_bin));

t_bound_bin = t_bin(1):0.01:t_bin(end);
%p_quantum_bound_bin = 1 - 1/2./( (1/4-phi)*(2.^(t_bound_bin)) - 1);

p_quantum_bound_bin = 1 - 1/2./(2.^(t_bound_bin-t_2)*(MOV-1)/pi-1);

NMOV = MOV/n;
x = -NMOV*sqrt(2.^t_bound_bin)/sqrt(1/4-NMOV^2);
p_classic_bound_bin = 1 - normcdf(x);

for temp = 1:length(t_bin)
    t = t_bin(temp);
    T = 2^t;
    b = floor(phi*T);
    delta = phi - b/T;
    l = 0:(T-1);
    ell = mod(b+l,T);
    
    alpha = 1/T * (1-exp(2*pi*1i*(T*delta-l))) ./ (1-exp(2*pi*1i*(delta-l/T)));
    p = abs(alpha).^2;
    p(ell+1) = p(l+1);
    p_quantum_bin(temp) = sum(p(1:T/4));
end

for temp = 1:length(t_classical_bin)
    t = t_classical_bin(temp);
    T = 2^t;
    p_classic_bin(temp) = binocdf(T/2+0.5,T,GT/n);
end

figure,

subplot(2,3,1)
plot(t_bin,p_quantum_bin,'-rs','markerfacecolor', [255, 195, 195]/255,'MarkerSize',12,'LineWidth',1);
hold on
plot(t_bound_bin,p_quantum_bound_bin,'--r','LineWidth',1);
hold on;
plot(t_classical_bin,p_classic_bin,'-bo','markerfacecolor', [195, 195, 255]/255,'MarkerSize',12,'LineWidth',1);
hold on;
plot(t_bound_bin,p_classic_bound_bin,'--b','LineWidth',1);
yticks(0.5:0.1:1)
ylim([0.4,1])
xticks(t_bin(1):2:t_bin(end))
xlim([t_bin(1), t_bin(end)])
set(gca, 'linewidth', 1.1, 'fontsize', fontsize, 'fontname', 'times')
grid on;
box on;
legend('Quantum','Quantum Lower','Classical', 'Classical Asymptotic','Location','southeast')
xlabel('log_2 (K \cdot 2^{\it s})')
ylabel('Pr[correct]')
title(['K = ', num2str(1)])

for tempK = 1:length(K_bin)
    K = K_bin(tempK);
    
    x = -NMOV*sqrt(2.^t_bound_bin*K)/sqrt(1/4-NMOV^2);
    p_classic_bound_bin = 1 - normcdf(x);

    for temp = 1:length(t_classical_bin)
        t = t_classical_bin(temp);
        T = 2^t*K;
        p_classic_bin(temp) = binocdf(T/2+0.5,T,GT/n);
    end

    subplot(2,3,1+tempK)
    plot(log2(K)+t_bin,binom_prob(p_quantum_bin,K),'-rs','markerfacecolor', [255, 195, 195]/255,'MarkerSize',12,'LineWidth',1);
    hold on
    plot(log2(K)+t_bound_bin, chernoff(p_quantum_bound_bin,K),'--r','LineWidth',1);
    hold on;
    plot(log2(K)+t_classical_bin,p_classic_bin,'-bo','markerfacecolor', [195, 195, 255]/255,'MarkerSize',12,'LineWidth',1);
    hold on;
    plot(log2(K)+t_bound_bin,p_classic_bound_bin,'--b','LineWidth',1);
%     yticks(0.5:0.1:1)
    ylim(lim_y{tempK})
    x_lim_temp = lim_x{tempK};
    xticks(x_lim_temp(1):2:x_lim_temp(2))
    xlim(x_lim_temp)
    set(gca, 'linewidth', 1.1, 'fontsize', fontsize, 'fontname', 'times')
    grid on;
    box on;
    legend('Quantum','Quantum Lower','Classical', 'Classical Asymptotic','Location','southeast')
    xlabel('log_2 (K \cdot 2^{\it s})')
    ylabel('Pr[correct]')
    title(['K = ', num2str(K)])
end






lim_y = cell(size(K_bin));
lim_y{1} = [0.998,1];
lim_y{2} = [0.99998,1];

t_2 = 20;
n = 2^t_2;
t_bin = 13:t_2-1;
t_classical_bin = t_bin;

MOV = 2^11;
GT = n/2-MOV;
phi = asin(sqrt(GT/n))/pi;
p_quantum_bin = zeros(size(t_bin));
p_classic_bin = zeros(size(t_classical_bin));

t_bound_bin = t_bin(1):0.01:t_bin(end);
%p_quantum_bound_bin = 1 - 1/2./( (1/4-phi)*(2.^(t_bound_bin)) - 1);

p_quantum_bound_bin = 1 - 1/2./(2.^(t_bound_bin-t_2)*(MOV-1)/pi-1);

NMOV = MOV/n;
x = -NMOV*sqrt(2.^t_bound_bin)/sqrt(1/4-NMOV^2);
p_classic_bound_bin = 1 - normcdf(x);

for temp = 1:length(t_bin)
    t = t_bin(temp);
    T = 2^t;
    b = floor(phi*T);
    delta = phi - b/T;
    l = 0:(T-1);
    ell = mod(b+l,T);
    
    alpha = 1/T * (1-exp(2*pi*1i*(T*delta-l))) ./ (1-exp(2*pi*1i*(delta-l/T)));
    p = abs(alpha).^2;
    p(ell+1) = p(l+1);
    p_quantum_bin(temp) = sum(p(1:T/4));
end

for temp = 1:length(t_classical_bin)
    t = t_classical_bin(temp);
    T = 2^t;
    p_classic_bin(temp) = binocdf(T/2+0.5,T,GT/n);
end


subplot(2,3,4)
plot(t_bin,p_quantum_bin,'-rs','markerfacecolor', [255, 195, 195]/255,'MarkerSize',12,'LineWidth',1);
hold on
plot(t_bound_bin,p_quantum_bound_bin,'--r','LineWidth',1);
hold on;
plot(t_classical_bin,p_classic_bin,'-bo','markerfacecolor', [195, 195, 255]/255,'MarkerSize',12,'LineWidth',1);
hold on;
plot(t_bound_bin,p_classic_bound_bin,'--b','LineWidth',1);
yticks(0.5:0.1:1)
ylim([0.52,1])
xticks(t_bin(1):2:t_bin(end))
xlim([t_bin(1), t_bin(end)])
set(gca, 'linewidth', 1.1, 'fontsize', fontsize, 'fontname', 'times')
grid on;
box on;
legend('Quantum','Quantum Lower','Classical', 'Classical Asymptotic','Location','southeast')
xlabel('log_2 (K \cdot 2^{\it s})')
ylabel('Pr[correct]')
title(['K = ', num2str(1)])

for tempK = 1:length(K_bin)
    K = K_bin(tempK);
    
    x = -NMOV*sqrt(2.^t_bound_bin*K)/sqrt(1/4-NMOV^2);
    p_classic_bound_bin = 1 - normcdf(x);

    for temp = 1:length(t_classical_bin)
        t = t_classical_bin(temp);
        T = 2^t*K;
        p_classic_bin(temp) = binocdf(T/2+0.5,T,GT/n);
    end

    subplot(2,3,4+tempK)
    plot(log2(K)+t_bin,binom_prob(p_quantum_bin,K),'-rs','markerfacecolor', [255, 195, 195]/255,'MarkerSize',12,'LineWidth',1);
    hold on
    plot(log2(K)+t_bound_bin, chernoff(p_quantum_bound_bin,K),'--r','LineWidth',1);
    hold on;
    plot(log2(K)+t_classical_bin,p_classic_bin,'-bo','markerfacecolor', [195, 195, 255]/255,'MarkerSize',12,'LineWidth',1);
    hold on;
    plot(log2(K)+t_bound_bin,p_classic_bound_bin,'--b','LineWidth',1);
%     yticks(0.5:0.1:1)
    ylim(lim_y{tempK})
    x_lim_temp = lim_x{tempK};
    xticks(x_lim_temp(1):2:x_lim_temp(2))
    xlim(x_lim_temp)
    set(gca, 'linewidth', 1.1, 'fontsize', fontsize, 'fontname', 'times')
    grid on;
    box on;
    legend('Quantum','Quantum Lower','Classical', 'Classical Asymptotic','Location','southeast')
    xlabel('log_2 (K \cdot 2^{\it s})')
    ylabel('Pr[correct]')
    title(['K = ', num2str(K)])
end





set(gcf, 'PaperSize', [18 12]); %Keep the same paper size，设置pdf纸张的大小，
saveas(gcf, 'quantum_voting.pdf');%保存命令，即在当前目录下生成名为WithMargin的pdf