clear all;
close all;
clc;

K_bin = 1:2:5;
MOV_bin = 2.^(6:2:10);
m = 4;

for K = K_bin
for MOV = MOV_bin
disp(['starting K=',num2str(K),' MOV=',num2str(MOV),' m=',num2str(m),'_stv'])

% m = 2;
% MOV = 2^6;
% K = 1;

t_bin = 4:16;
t2 = 20;
num_exp = 1e5;
mf = factorial(m);
n = 2^t2;

% Assume the profile uses the alphabic order
nPF = ones(mf,1)/mf;
PF = nPF*(n-2*MOV);
PF(1) = PF(1) + MOV;
PF(2) = PF(2) + MOV;
nPF = PF/n;
m1f = mf/m;
phi_bin = asin(sqrt(nPF))/pi;

permutation = perms(m:-1:1);

tic
%% Calculate Pr[correct] for the classical algorithm
p_correct_c = zeros(m, length(t_bin));
for temp = 1:length(t_bin)
    t = t_bin(temp);
    T = 2^t*K;
    samples_c = zeros(mf,num_exp);
    parfor temp_exp = 1:num_exp
        samples_c(:,temp_exp) = mnrnd(T,nPF')';
    end
    
    % Calculate the STV winner
    scores_c = zeros(m,num_exp);
    parfor temp_data = 1:num_exp
        data_temp = samples_c(:, temp_data);
        winner = stv(data_temp, permutation, m);
        scores_temp = zeros(m,1);
        scores_temp(winner) = 1;
        scores_c(:, temp_data) = scores_temp;
    end

    p_correct_c(:,temp) = sum(cal_prob(scores_c),2)/num_exp;
end
toc
disp('classical finished')


tic
%% Calculate the distribution for the quantum algorithm
p_bin_q = cell(size(t_bin));
est_q = cell(size(t_bin));    % The estimated nPF for any output

% For the quantum algorithm
for temp = 1:length(t_bin)
    t = t_bin(temp);
    T = 2^t;
    temp_p_mat_q = zeros(mf, T);
    est_q{temp} = sin((0:1/T:1-1/T)*pi).^2;
    for temp_vote = 1:mf
        phi = phi_bin(temp_vote);
        b = floor(phi*T);
        delta = phi - b/T;
        l = 0:(T-1);
        ell = mod(b+l,T);
        alpha = 1/T * (1-exp(2*pi*1i*(T*delta-l))) ./ (1-exp(2*pi*1i*(delta-l/T)));
        p = abs(alpha).^2;
        p(ell+1) = p(l+1);
        temp_p_mat_q(temp_vote,:) = cumsum(p);
    end
    p_bin_q{temp} = temp_p_mat_q;
end
toc

%% Calculate the estimated probability to win if K=1 (for quantum)
% We always set the first candidate as the ground truth winner
p_correct_q_1 = zeros(m, length(t_bin));
for temp = 1:length(t_bin)
    temp_p_mat_q = p_bin_q{temp};
    samples_q = zeros(mf, num_exp);
    parfor temp_vote = 1:mf
        p_q = temp_p_mat_q(temp_vote,:);
        samples_q(temp_vote,:) = mySampling(p_q, num_exp, est_q{temp});
    end

    % Calculate the weights
    scores_q = zeros(m,num_exp);
    parfor temp_data = 1:num_exp
        data_temp = samples_q(:, temp_data);
        winner = stv(data_temp, permutation, m);
        scores_temp = zeros(m,1);
        scores_temp(winner) = 1;
        scores_q(:, temp_data) = scores_temp;
    end

    % Decide the winning probability of each candidate
    % We break ties uniformly
    p_correct_q_1(:,temp) = sum(cal_prob(scores_q),2)/num_exp;
end
toc

%% Calculate Pr[correct] for the defined K value (for quantum)
p_correct_q_k = zeros(m, length(t_bin));
for temp = 1:length(t_bin)
    samples = mySampling2(cumsum(p_correct_q_1(:,temp)), num_exp, K);
    scores = zeros(m,num_exp);
    for tempm = 1:m
        scores(tempm,:) = sum(samples == tempm, 1)';
    end
    p_correct_q_k(:,temp) = sum(cal_prob(scores),2)/num_exp;
end
toc
disp('quantum finished')

% figure,
% subplot(1,2,1)
% plot(t_bin,p_correct_c(1,:),'r')
% hold on;
% plot(t_bin,p_correct_q_1(1,:),'b')
% grid on;
% 
% subplot(1,2,2)
% plot(t_bin,p_correct_c(1,:),'r')
% hold on;
% plot(t_bin,p_correct_q_k(1,:),'b')
% grid on;



save(['K_',num2str(K),'_MOV_',num2str(MOV),'_m_',num2str(m),'_stv.mat'], 't_bin','p_correct_q_1','p_correct_c','p_correct_q_k')
end
end

