import pandas as pd
from pathlib import Path
from tqdm import tqdm

num_positions = 0
for file in tqdm(Path("../unified_data_cache/waymo_train").glob("**/agent_data_dt*.feather"), total=487000):
    num_positions += len(pd.read_feather(file, columns=["x"]))
    
print(f"waymo_train num_positions={num_positions}")
