# Graph AutoEncoder (GAE)

## Overview  
Graph AutoEncoder is an unsupervised learning method for GRN representation. It learns to encode and reconstruct both node and edge features, capturing local and global graph structure.

## Model Architecture  
- **Encoder**: GNN that maps each node (and its incident edge) into a latent vector  
- **Decoder**: Reconstructs node features and edge contributions from latent vectors  
- **Loss**: MSE reconstruction loss on node features **and** edge‐contribution scalars

## Key Features  
- Fully unsupervised  
- Jointly preserves node and edge information  
- Tailored for gene regulatory networks (ECv + expression)

## Usage  
```bash
cd SupGCL/Pretrain/GAE
python main.py \
  --tcga-graphs-path ../../data/GRN_dataset/Breast/Breast_tcga_graphs.pkl \
  --checkpoint-dir ./checkpoints \
  --log-dir ./runs \
  --batch-size 4 \
  --num-epochs 3000 \
  --learning-rate 1e-4 \
  --in-channels 1 \
  --hidden-channels 64 \
  --out-channels 64
```

**Arguments**

- `--tcga-graphs-path`  : Path to pickled TCGA graphs (`.pkl`)  
- `--checkpoint-dir`    : Directory to save model checkpoints  
- `--log-dir`           : TensorBoard log directory  
- `--batch-size`        : Training batch size (default: 4)  
- `--num-epochs`        : Number of epochs (default: 3000)  
- `--learning-rate`     : Learning rate for optimizer (default: 1e-4)  
- `--in-channels`       : Dimensionality of node features (default: 1)  
- `--hidden-channels`   : Hidden GNN channel size (default: 64)  
- `--out-channels`      : Output embedding size (default: 64)  

