# utils.py
import random
import torch

def set_seed(seed: int):
    """Set random seed to ensure reproducibility"""
    random.seed(seed)
    torch.manual_seed(seed)
    if torch.cuda.is_available():
        torch.cuda.manual_seed(seed)
