# GraphCL: Graph-level Contrastive Learning

## Overview
GraphCL is a self-supervised graph representation learning framework that leverages graph-level contrastive learning. It generates two augmented views of each graph via virtual gene knockdown and maximizes agreement between their representations using a contrastive loss.

## Model Architecture
- **Graph Encoder**: 5-layer TransformerConv-based GNN to encode node features
- **Projection Head**: MLP that projects graph embeddings to a contrastive space
- **Loss Function**: NT-Xent (Normalized Temperature-scaled Cross Entropy) loss between graph-level embeddings of two augmented views

## Key Features
- Graph-level contrastive learning
- Virtual knockdown data augmentation (randomly zeroing out a node and removing its edges)
- 5-layer TransformerConv encoder for expressive graph representations
- Self-supervised learning without external labels

## Usage

```bash
cd SupGCL/Pretrain/GraphCL
python train.py \
  --tcga-graphs-path ../../data/GRN_dataset/Breast/Breast_tcga_graphs.pkl \
  --batch-size 4 \
  --num-epochs 3000 \
  --learning-rate 1e-4 \
  --temperature 0.25 \
  --hidden-dim 64 \
  --out-dim 64 \
  --proj-hidden-dim 64 \
  --proj-out-dim 64 \
  --num-heads 8
```

**Arguments**

- `--tcga-graphs-path` : Path to TCGA graph data pickle file (`.pkl`)  
- `--checkpoint-dir`   : Directory to save model checkpoints  
- `--log-dir`          : Directory for TensorBoard logs  
- `--seed`             : Random seed (default: 42)  
- `--batch-size`       : Batch size (default: 8)  
- `--learning-rate`    : Learning rate (default: 1e-4)  
- `--num-epochs`       : Number of training epochs (default: 3000)  
- `--temperature`      : Temperature parameter for NT-Xent loss (default: 0.25)  
- `--hidden-dim`       : Hidden dimension of GraphEncoder (default: 64)  
- `--out-dim`          : Output dimension of GraphEncoder (default: 64)  
- `--proj-hidden-dim`  : Hidden dimension of projection head (default: 64)  
- `--proj-out-dim`     : Output dimension of projection head (default: 64)  
- `--num-heads`        : Number of attention heads in TransformerConv (default: 8)  

