# Self-supervised Graph Representation Learning (SGRL)

## Overview
SGRL is a self-supervised framework that learns graph representations through an online–target network architecture with multi-hop diffusion for global context.

## Model Architecture
- **Online Network:** Encodes node features and predicts target projections  
- **Target Network:** Momentum-updated encoder for stability  
- **Predictor:** MLP that projects diffused online features into target space  
- **Loss Function:** Contrastive loss between online predictions and target projections (RSM)  

## Key Features
- **Online–target dual encoders** with EMA updates  
- **Multi-hop diffusion** (Topology-based Constraint Mechanism) for global context  
- **Momentum-based updates** to stabilize learning  
- **Injection-free self-supervision** (no labels required)  

## Usage
```bash
cd SupGCL/Pretrain/SGRL
python main.py \
  --tcga-graphs-path ../../data/GRN_dataset/Breast/Breast_tcga_graphs.pkl \
  --checkpoint-dir ./checkpoints \
  --log-dir ./runs \
  --batch-size 4 \
  --num-epochs 3000 \
  --lr-online 1e-4 \
  --lr-target 1e-4 \
  --global-hop 3 \
  --hidden-channels 64 \
  --proj-dim 64 \
  --num-heads 8 \
  --momentum 0.99
```

**Arguments**

- `--tcga-graphs-path`   : Path to pickled TCGA graphs (`.pkl`)  
- `--checkpoint-dir`     : Directory to save online/target checkpoints  
- `--log-dir`            : Directory for TensorBoard logs  
- `--seed`               : Random seed (default: 42)  
- `--batch-size`         : Batch size (default: 4)  
- `--num-epochs`         : Number of epochs (default: 3000)  
- `--lr-online`          : Learning rate for online network (default: 1e-4)  
- `--lr-target`          : Learning rate for target network (default: 1e-4)  
- `--global-hop`         : Number of diffusion hops (default: 3)  
- `--hidden-channels`    : Hidden layer dimension (default: 64)  
- `--proj-dim`           : Projection dimension (default: 64)  
- `--num-heads`          : TransformerConv heads (default: 8)  
- `--momentum`           : EMA coefficient for target updates (default: 0.99)  


