## Self-supervised Discovery of Human Actons from Long Kinematic Videos

_anonymization version_

### Prerequisites:
pip install pytorch-lightning  
pip install pytorch-lightning-bolts  
pip install aniposelib  
pip install wandb  
pip install gym  
pip install test-tube  

if you are using python >= 3.8, might want to use this once `ln -s ~/anaconda3/lib/libopenh264.so ~/anaconda3/envs/<env_name>/lib/libopenh264.so.5`


### Data Preparation

1. Make a directory besides this repo and name it `aistplusplus`
2. Download from [AIST++](https://google.github.io/aistplusplus_dataset/download.html) until it looks like
```angular2html
├── annotations
│   ├── cameras
│   ├── ignore_list.txt
│   ├── keypoints2d
│   ├── keypoints3d
│   ├── motions
│   └── splits
└── video_list.txt
```

### How to run:

1. First use `python pretrain.py --cfg configs/<some configuration file>`, which will 
   create a folder under `logs` to save all logs and checkpoints for this run; if there has been 
   such a folder, it will not replace it. 
   
2. Then use `python cluster_advanced.py --cfg configs/<some configuration file>`, which will 
   create its own folder if experiment specified by `NAME` in `configs/<some configuration file>` if not present. 
   
3. Then use files in `rnn_exp` for classification tasks.

### Repertoire

#### representation learning losses:

1. SimCLR (use ALGO: SimCLR in config)
2. TCC (use ALGO: TCC in config)
3. TCN (use ALGO: TCN in config)

#### architectures:

1. Transformer (use ARCH: Transformer in config)

2. Temporal Convolution (use ARCH: Tconv in config)

#### experiment settings:

1. For NMI experiment, set `SPLIT` in `configs/<some configuration file>` to `1234`
2. For genre classification, set `SPLIT` in `configs/<some configuration file>` to `4321`

#### cluster:

1. kmeans_skl: use this, from SKLearn

#### metrics:

1. Kendall's Tau

2. NMI

3. language entropy