"""
These models have been pre-trained using self-supervised learning. The models can also be used without pre-training
and overwritten for your own research.

Here's an example for using these as pretrained models.

.. code-block ::

    from pl_bolts.models.self_supervised import CPC_v2

    images = get_imagenet_batch()

    # extract unsupervised representations
    pretrained = CPC_v2(pretrained=True)
    representations = pretrained(images)

    # use these in classification or any downstream task
    classifications = classifier(representations)

"""
from plb.models.self_supervised.tcc_aal.tcc_module import TCC
from plb.models.self_supervised.tcn_aal.tcn_module import TCN
from plb.models.self_supervised.simclr_aal.simclr_module import SimCLR

__all__ = [
    "SimCLR",
    "TCC",
    "TCN",
]
