import json
from dataclasses import dataclass


def make_dataclass_from_dict(d: dict, name='Config'):
    """Create dataclass from any nested dict"""
    if isinstance(d, dict):
        @dataclass
        class Wrapped:
            __annotations__ = {k: type(v) for k, v in d.items()}

        Wrapped.__qualname__ = Wrapped.__name__ = name
        config = Wrapped(**d)

    for key, value in vars(config).items():
        if isinstance(value, dict):
            setattr(config, key, make_dataclass_from_dict(value))
    return config


def merge_configs(base_config, extension_config):
    """Merge base config with extension config
    if both configs have the same field, extension is taken"""
    for key, val in extension_config.items():
        if type(val) == dict:
            if key in base_config:
                base_config[key].update(val)
            else:
                base_config[key] = val
        else:
            base_config.update({key: val})
    return base_config
