## Requirements
Please note that some of these experiments make use of the Mujoco simulator (http://www.mujoco.org/) that requires a license.
We also assume that Mujoco has been installed previously. MuJoCo : [mujoco-py](https://github.com/openai/mujoco-py)

We recommend to use conda to create a virtual environment

```
conda create -n qdpg python=3.7
```

MPI 

```
sudo apt-get install mpich
```

Install requirements
```
pip install -r requirements.txt
```

## Run experiments
Place yourself at the root of the code directory
```
cd qd-pg
```

QD-PG MAP-Elites on POINT-MAZE
```
./experiments/td3_me_point_maze.sh
```

QD-PG MAP-Elites on ANT-MAZE
```
./experiments/td3_me_ant_maze.sh
```

QD-PG MAP-Elites on ANT-TRAP
```
./experiments/td3_me_ant_maze.sh
```

If you want to run Q-PG or D-PG, simply go to the corresponding configuration file in `experiments/configs/`, 
open the desired configuration file and change `novelty_size` to 0 (Q-PG) or to be equal to `num_workers` (D-PG).


Results are stored in the ./out folder which is created automatically


## External code

The TD3 implementation comes from
```
https://github.com/sfujim/TD3
```



