from abc import ABC, abstractmethod


class Novelty(ABC):
    """Defines the way novelty scores are computed"""
    def __init__(self, qd_strategy, config):
        self.qd_strategy = qd_strategy
        self.config = config

    @abstractmethod
    def compute_novelty_score(self, behavior, *args):
        """Compute novelty score of the given behavior"""
        pass

    @abstractmethod
    def update(self):
        """Update the method if needed (ex: update neural nets if RND is used)"""
        pass