from io import StringIO

import psycopg2 as pg


def write_losses(run_id, steps, losses, target_distances, database, user, password, host):
    connection = pg.connect(user=user, password=password, host=host, database=database)
    cursor = connection.cursor()

    rows = [f'{run_id}\t{step}\t{loss}\t{target_distance}\n' for step, loss, target_distance in zip(steps, losses, target_distances)]
    with StringIO() as f:
        f.writelines(rows)
        f.seek(0)
        cursor.copy_from(f, 'losses', columns=('run_id', 'step', 'loss', 'target_distance'))
    cursor.execute('UPDATE runs SET complete = true WHERE run_id = %s', (run_id,))

    connection.commit()
    connection.close()
    
    
def write_losses_no_distances(run_id, steps, losses, database, user, password, host):
    connection = pg.connect(user=user, password=password, host=host, database=database)
    cursor = connection.cursor()

    rows = [f'{run_id}\t{step}\t{loss}\n' for step, loss in zip(steps, losses)]
    with StringIO() as f:
        f.writelines(rows)
        f.seek(0)
        cursor.copy_from(f, 'losses', columns=('run_id', 'step', 'loss'))
    cursor.execute('UPDATE runs SET complete = true WHERE run_id = %s', (run_id,))

    connection.commit()
    connection.close()