## Requirements

- **Python**: 3.9.12
- **Dependencies**: see `requirements.txt`

### Installation
```bash

conda create -n sats python=3.9.12 -y
conda activate sats
pip install -r requirements.txt
```

---

## Datasets

Place datasets under `data/`:
```
data/
  Figurative_expression/
  pragmatic/
  sarcasm_v2/
```
Each folder includes `preprocessing.ipynb` to convert raw data into the format used by our code.

> **Note:** Please keep the folder names as above to match default paths in the configs.

---

## Quick Start

### 1) Classification on SC V2

1. Edit `configs/config.yaml`.
   - All parameters are documented inside the YAML.
   - Set the target **input file** and **backbone model**.
   - If you want to apply the **topology** method to a fine-tuned model, run `finetune_for_SCV2.ipynb` to train a model **for each dataset**, then set `model_path` in `configs/config.yaml` to the directory where the checkpoints were saved.

2. Run feature extraction and evaluation:
```bash
bash extraction.sh        # start feature extraction
python predict.py         # show results
```

> **Important (ripser rebuild):** If a feature folder with the same model/dataset name already exists, re-running may trigger a crash in `ripser` during rebuild. **Delete the target feature directory before re-running** the experiment.

### 2) Representation Topology Divergence (RTD)

Open `RTD.ipynb` and run the cells in order.

### 3) Scenario Anchored Topological Scoring (SATS)

Open `SATS.ipynb` and run the cells in order.

---

## Reproducibility

- Set `seed` in `configs/config.yaml` for deterministic runs where supported.
- Record package versions via `pip freeze > freeze.txt` if needed.

---

## Troubleshooting

- **ripser crash on re-run**: Remove the existing feature directory before re-running (see note above).
- **Module/script paths**: Ensure the called script path matches your repo layout (e.g., `scripts/predict.py`).
