import os
import sys
from omegaconf import OmegaConf
from hydra import initialize_config_dir, compose

def main():
    config_path = os.path.abspath("./configs") 
    with initialize_config_dir(config_dir=config_path, version_base=None):
        cfg = compose(config_name="config")
        print(cfg.model.model_name)
        print(cfg.model.model_path)
        print(cfg.data.name)

if __name__ == "__main__":
    main()