(define (domain countdown)
  (:types num - object)
   (:predicates 
    ;; active predicate is used to track which values are available for arithematic operation in the state
    (active ?o - num)
    (goalreached)
   )
		
   (:functions 
	(value ?o - num)
	(targetvalue)
    ;; Total count of available numbers
	(numactive)
   )

   ;; Each action corresponding to an operator
   ;; Each operation copies the resultant number into the first argument and deactivates the second one
   (:action add
       :parameters (?a ?b - num) 
       :precondition (and (active ?a) (active ?b) (not (= ?a ?b))
                     )
       :effect (and
                (decrease (numactive) 1)
                (increase (value ?a) (value ?b))
                (not (active ?b))
                )
    )

   (:action subtract
       :parameters (?a ?b - num) 
       :precondition (and (active ?a) (active ?b) (>= (value ?a) (value ?b)) (not (= ?a ?b))
                     )
       :effect (and
                (decrease (numactive) 1)
                (decrease (value ?a) (value ?b))
                (not (active ?b))
                )
    )

   (:action multiply
       :parameters (?a ?b - num) 
       :precondition (and (active ?a) (active ?b) (not (= ?a ?b))
                     )
       :effect (and
                (decrease (numactive) 1)
                (assign (value ?a) (* (value ?a) (value ?b)))
                (not (active ?b))
                )
    )

   (:action divide
       :parameters (?a ?b - num) 
       :precondition (and (active ?a) (active ?b) (> (value ?b) 0) (not (= ?a ?b))
                     )
       :effect (and
                (decrease (numactive) 1)
                (assign (value ?a) (/ (value ?a) (value ?b)))
                (not (active ?b))
                )
    )

   ;; Goal reached if the number of active values is one, and it is equal to the targetvalue
   (:action checkgoal
       :parameters (?a - num)
       :precondition  (and (active ?a)
                           (= (numactive) 1)
                           (= (value ?a) (targetvalue))
                      )
       :effect (and (goalreached)
		    )
	)
)   