#!/bin/bash

# Download MNIST data
if [ ! -f "mnist_all.mat" ]
then
    echo "Downloading dataset ..."
    wget https://cs.nyu.edu/~roweis/data/mnist_all.mat
fi

# Create two-view MNIST
if [ ! -f "MNIST.mat" ]
then
    matlab -nodisplay -nosplash -nodesktop -r "run('createMNIST.m'); exit;"
fi

# Run the algorithm
python mnist_demo.py \
--z_dim=10 \
--c1_dim=20 \
--c2_dim=50 \
--num_iters=20 \
--batchsize1=200 \
--batchsize2=1000 \
--lr_max=1e0 \
--lr_min=1e-3 \
--weight_decay_theta=1e-4 \
--weight_decay_eta=1e-1 \
--beta=1e0 \
--_lambda=1e2 \
--inner_epochs=10 \
--phi_num_layers=3 \
--phi_hidden_size=64 \
--tau_num_layers=3 \
--tau_hidden_size=64 \

