# MAGNet: Motif-Agnostic Generation of Molecules from Shapes

# Setup
First, please create a new environment by running 
```
conda env create -f environment.yml
```
and install the MAGNet package via
```
pip install -e .
```
Additionally, please install the [guacamol](https://github.com/BenevolentAI/guacamol) and [torchcfm](https://github.com/atong01/conditional-flow-matching) packages.

# Training
In a first step, place your dataset at `data/` and preprocess with
```
python src/preprocess/decomposition_pp.py
```

We provide the vocabulary for ZINC in this repository, but you can also recreate this via
```
python src/preprocess/extract_shapes.py
```

Next, please specify your W&B project in `src/utils.py` to determine to which project (and collection) the training data should be logged.

You can now run 
```
python experiments/train.py
python experiments/train_flow.py
```
to train your MAGNet model. The scripts include the hyperparameters as specified in the paper.

# Inference
You can find a visualization of MAGNet's reconstruction and sampling at `experiments/visualize_sampling.ipynb`. Additionally, `experiments/visualize_shapes.ipynb` includes a visualization of the shape decomposition as well as the vocabulary.
