import json
import re

from datasets import load_dataset

def extract_answers_from_json(answers_file_path):
    # 读取答案 JSON 文件
    with open(answers_file_path, 'r') as file:
        data = json.load(file)
    
    # 定义正则表达式，匹配左括号、左方括号或左花括号后跟字母 A 到 Z（不区分大小写）
    pattern = re.compile(r'[\(\[\{]\s*(\d{1,2}|[A-Z])', re.IGNORECASE)
    
    extracted_answers = []
    none_count = 0  # 计数 None 的数量
    
    for entry in data:
        answer = entry.get('answer', '')  # 获取 answer 字段
        
        # 查找所有匹配的字符串
        matches = pattern.findall(answer)
        
        if matches:
            # 如果找到了匹配项，取最后一个匹配项并转换为大写
            if matches[-1].strip().isdigit():
                if 1 <= matches[-1].strip().isdigit() <= 26:
                    # 将数字转换为对应的大写字母
                    extracted_answers.append(chr(int(matches[-1].strip()) + 64))                
            else:
                extracted_answers.append(matches[-1].upper())
        else:
            extracted_answers.append(None)  # 没有匹配到时返回 None
            none_count += 1  # 增加 None 计数
    
    return extracted_answers, none_count

def get_correct_answers(correct_file_path):
    # 读取正确答案 JSON 文件
    data = load_dataset("Fsoft-AIC/CodeMMLU", "code_repair")["test"]
    
    correct_answers = []
    
    for entry in data:
        correct = entry.get('answer', '')  # 获取 answer 字段
        correct_answers.append(correct.upper())  # 保存 correct 字段并转换为大写
    
    return correct_answers

def calculate_accuracy(extracted_answers, correct_answers):
    # 计算准确率
    total = len(extracted_answers)
    correct_count = 0
    
    for extracted, correct in zip(extracted_answers, correct_answers):
        if extracted and extracted == correct[-1].upper():  # 统一转换为大写进行比较
            correct_count += 1
    
    accuracy = correct_count / total if total > 0 else 0
    return accuracy


# 调用函数并打印提取的结果、准确率和 None 的数量
answers_file_path = "LLAMA3_MATHQA_EVAL.json"  # 替换为你的答案 JSON 文件路径
correct_file_path = "AI_School_main_vllm/data/eval_datasets/MMLU_PRO/data/math.json"  # 替换为你的正确答案 JSON 文件路径

# 提取答案和正确答案
extracted_answers, none_count = extract_answers_from_json(answers_file_path)
correct_answers = get_correct_answers(correct_file_path)

# 计算准确率
accuracy = calculate_accuracy(extracted_answers, correct_answers)

print(f"Accuracy: {accuracy * 100:.2f}%")
print(f"Number of None entries: {none_count}")
