import json
import re

def extract_answers_from_json(answers_file_path, student_field):
    # 读取答案 JSON 文件
    with open(answers_file_path, 'r') as file:
        data = json.load(file)
    
    # 定义正则表达式，匹配左括号、左方括号或左花括号后跟字母 A 到 Z（不区分大小写）
    pattern = re.compile(r'<\d{1}>', re.IGNORECASE)
    
    extracted_answers = []
    none_count = 0  # 计数 None 的数量
    
    for entry in data:
        answer = entry.get(student_field, '')  # 获取指定学生字段的答案
        
        # 查找所有匹配的字符串
        matches = pattern.findall(answer)
        
        if matches:
            # 如果找到了匹配项，取最后一个匹配项
            last_match = matches[-1].strip('<>')  # 移除尖括号
            extracted_answers.append(last_match)
        else:
            extracted_answers.append(None)  # 没有匹配到时返回 None
            none_count += 1  # 增加 None 计数
    
    return extracted_answers, none_count


def calculate_accuracy(extracted_answers):
    # 计算准确率
    total = len(extracted_answers)
    correct_count = 0
    
    for extracted in extracted_answers:
        if extracted == "1":
            correct_count += 1
    
    accuracy = correct_count / total if total > 0 else 0
    return accuracy

def compare_student_answers(studentA_answers, studentC_answers):
    A_correct_C_wrong = 0
    A_wrong_C_correct = 0

    for a_ans, c_ans in zip(studentA_answers, studentC_answers):
        if a_ans == "1" and c_ans == "0":
            A_correct_C_wrong += 1
        elif a_ans == "0" and c_ans == "1":
            A_wrong_C_correct += 1

    return A_correct_C_wrong, A_wrong_C_correct


# 调用函数并打印提取的结果、准确率和 None 的数量
answers_file_path = "JUDGE_EVAL.json"  # 替换为你的答案 JSON 文件路径

# 提取答案和正确答案
studentA_answers, none_count_A = extract_answers_from_json(answers_file_path, '<StudentA>')
studentC_answers, none_count_C = extract_answers_from_json(answers_file_path, '<StudentC>')


# 计算准确率
accuracy_A = calculate_accuracy(studentA_answers)
accuracy_C = calculate_accuracy(studentC_answers)

# 比较两位学生的答案
A_correct_C_wrong, A_wrong_C_correct = compare_student_answers(studentA_answers, studentC_answers)

print(f"Accuracy of StudentA: {accuracy_A * 100:.2f}%")
print(f"Accuracy of StudentC: {accuracy_C * 100:.2f}%")
print(f"Number of None entries for StudentA: {none_count_A}")
print(f"Number of None entries for StudentC: {none_count_C}")
print(f"Number of questions where StudentA is correct and StudentC is wrong: {A_correct_C_wrong}")
print(f"Number of questions where StudentA is wrong and StudentC is correct: {A_wrong_C_correct}")
