# TG-Gen: A Deep Generative Model Framework for Temporal Graphs

## Instalation

We recommend using python3.8 or later and creating a virtual environment using the `venv` package. Once a virtual environment is made, all depenencies can be installed via our `requirements.txt` file, for example:




## Running custom train and eval 
Hyperparameters for the model are determined by `config.yaml`. One can customize the hyperparameters by directly editing that file, and then run our train (and eval) script by:

```
python train.py
```


## Reproducing results from our work
Command line arguments for hyperparamers will override `config.yaml`. One can recreate the link prediction results from our paper by running `train.py` with the following arguments for each dataset:


### Wikipedia
```
python train.py --embedding_dim=100 --eps=1.6609241492524165 --feats_model_h_dim=128 --lr=0.0008475205788940288 --lr_ds=0.0005998127563615001 --memory_dim=50 --n_comp=4 --n_sampled_src=300 --num_feats=25 --num_neighbors=40 --threshold_epochs=20 --threshold_eps=0.7237959430593633 --time_dim=76
```

### Reddit 
```
python train.py --embedding_dim=100 --eps=2.6497328363650143 --feats_model_h_dim=128 --lr=0.00018255360305197856 --lr_ds=0.0008210978854389993 --memory_dim=50 --n_comp=32 --n_sampled_src=400 --num_feats=50 --num_neighbors=10 --threshold_epochs=10 --threshold_eps=0.6299062006291517 --time_dim=400
```

### CBS
```
python train.py --embedding_dim=200 --eps=1.10133554299063 --feats_model_h_dim=128 --lr=0.00024449883587603793 --lr_ds=0.0003691275410169613 --memory_dim=300 --n_comp=4 --n_sampled_src=600 --num_feats=25 --num_neighbors=200 --threshold_epochs=10 --threshold_eps=0.7700495460306547 --time_dim=800
```

## Generating Synthetic Data

Users may modify the `get_synth_data.py` file directly with desired datasets, batch sizes, and total data size and then generate synthetic data by running:
```
python get_synth_data.py
```
