import qubovert
import numpy as np
import instance_setup
import inst_utils


for inst_config_idx in range(instance_setup.numb_inst_config):
    #print(inst_config_idx)
    J, norm, inst_seed, GE_base, N, T, rho, MIS, meta, clss = instance_setup.get_config(inst_config_idx)
    
    print(inst_config_idx, N, inst_seed)
    instance_path = f"./instance/{clss}/N_{N}/"
    GE = min(inst_utils.get_GE(instance_path, N, inst_seed), GE_base)

    qubo = qubovert.utils.matrix_to_qubo(J)
    
    anneal_res = qubovert.sim.anneal_quso(qubo, num_anneals=400,anneal_duration=1000)

    print(GE, anneal_res.best.value)

    instance_path = f"./instance/{clss}/N_{N}/"
    
    inst_utils.save_GE(instance_path, N, inst_seed, GE, "min")
        