import numpy as np
import sys
import os


def get_best_median(model_id, group_name):
    path = f"./out/m_{model_id}" + "/" + group_name + "/"
    if(not os.path.exists(path)):
        return -1
    files = os.listdir(path)
    medians = []
    for filename in files:
        if(os.path.exists(path + filename + "/rew.txt")):
            medians.append(np.median(np.loadtxt(path + filename + "/rew.txt")))
    print(medians)
    if(len(medians) == 0):
        return -1
    return np.max(medians)


group_names = ["CHOOK_4T_N_100_70","MIS_2T_80_100","SK_1T_N_100","SK_1T_N_800"]
#group_names = ["MIS_2T_80_100","SK_1T_N_100","SK_1T_N_800"]


model_ids = [-2,4]

best_meds = [[] for _ in model_ids]

for idx1, group_name in enumerate(group_names):

    for idx2, model_id in enumerate(model_ids):
        best_med = get_best_median(model_id, group_name)
        best_meds[idx2].append(best_med)
        print(group_name, model_id, best_med)


print(best_meds)

T_list = [400, 200, 100, 800]

best_meds = np.array(best_meds)

TTS = (np.log(0.01)/np.log(1 - best_meds))*np.array(T_list).reshape(1,-1)
np.set_printoptions(suppress=False, precision=3)
print(TTS)
