import numpy as np
import matplotlib.pyplot as plt


paths = [ "eval/m_4_CHOOK_1T_N_50_%i/eval_WPE_tuned_90/rew_centered.txt", "eval/m_4_CHOOK_1T_N_50_%i/eval_WPE_tuned_80/rew_centered.txt", "eval/m_4_CHOOK_1T_N_50_%i/eval_WPE_tuned_70/rew_centered.txt", "eval/m_-2_CHOOK_1T_N_50_%i/eval_CAC_tuned_90/rew_centered.txt", "eval/m_-2_CHOOK_1T_N_50_%i/eval_CAC_tuned_80/rew_centered.txt", "eval/m_-2_CHOOK_1T_N_50_%i/eval_CAC_tuned_70/rew_centered.txt"]


labels = [r"cNPIM trained on $\alpha = 0.90$ (base weights)", r"cNPIM fine tuned on $\alpha = 0.80$", r"cNPIM fine tuned on $\alpha = 0.70$", r"CAC tuned on $\alpha = 0.90$ (IM baseline)", r"CAC tuned on $\alpha = 0.80$", r"CAC tuned on $\alpha = 0.70$"]
alpha_list = [70,75,80,85,90,95]


T = 50


plt.figure(figsize = (5,3.5))
plt.yscale("log")
plt.ylabel("TTS\n(number of steps to 99% accuracy)", fontsize = 12)
plt.xlabel(r"$\alpha$"+"\n(hardness parameter)", fontsize = 12)
for path, label in zip(paths, labels):

    TTS = []
    for a in alpha_list:
        rew = np.loadtxt(path % a)
        TTS.append(T*np.log(0.01)/np.log(1 - np.median(rew)))


    if(label.startswith("CAC")):
        plt.plot([a/100 for a in alpha_list], TTS, label = label, dashes = [3,3], marker = "+")
    else:
        plt.plot([a/100 for a in alpha_list], TTS, label = label, marker = "o")

plt.legend(fontsize=8)
plt.tight_layout()

plt.savefig("./figure.png")
plt.show()
plt.close()



