#encoding=utf-8
import torch
import torch.nn as nn
import torch.nn.functional as F

from torch_geometric.nn import GraphConv


class MixerGenerator(nn.Module):
    def __init__(self, args):
        super(MixerGenerator, self).__init__()

    def postprocess(self, inputs, method='hard_gumbel', temperature=5.):

        def listify(x):
            return x if type(x) == list or type(x) == tuple else [x]

        def delistify(x):
            return x if len(x) > 1 else x[0]

        if method == 'soft_gumbel':
            softmax = [F.gumbel_softmax(e_logits.contiguous().view(-1,e_logits.size(-1))
                       / temperature, hard=False).view(e_logits.size())
                       for e_logits in listify(inputs)]
        elif method == 'hard_gumbel':
            softmax = [F.gumbel_softmax(e_logits.contiguous().view(-1,e_logits.size(-1))
                       / temperature, hard=True).view(e_logits.size())
                       for e_logits in listify(inputs)]
        else:
            softmax = [F.softmax(e_logits / temperature, -1)
                       for e_logits in listify(inputs)]

        return [delistify(e) for e in (softmax)]

    def forward(self, prob_graph, ansatz_graph, n_layer):

        return ansatz_graph
