
###############################################################################
# Script for reproducing the results of CQR paper
###############################################################################

# import sys

# print(sys.path)
import numpy as np
from reproducible_experiments.run_cqr_experiment import run_experiment
#from run_cqr_experiment import run_experiment


# list methods to test
test_methods = [
                'Winkler',
                'QFR-W',
                'IR',
                'QR',
                ]

# list of datasets
dataset_names = [
                'concrete',
                'boston',
                'naval',
                'energy',
                'wine',
                'power',
                'protein',
                'kin8nm',
                'yacht',
                ]


# vector of random seeds
random_state_train_test = np.arange(0,20) 
for dataset_name_id in range(len(dataset_names)):
    for test_method_id in range(len(test_methods)):
        for random_state_train_test_id in range(len(random_state_train_test)):
            dataset_name = dataset_names[dataset_name_id]
            test_method = test_methods[test_method_id]
            random_state = random_state_train_test[random_state_train_test_id]
            print('test_method: ', test_method)

            # run an experiment and save average results to CSV file
            run_experiment(dataset_name, test_method, random_state, True, verbose=False)
