#!/bin/bash

set -e

export FORCE_TORCHRUN=1 
export NNODES=1
export NODE_RANK=8


model_name=qwen3-0.6b-embedding-e5data


torchrun \
  --nnodes=$NNODES --nproc_per_node=$NODE_RANK \
  src/run.py \
  --deepspeed ./scripts/zero2.json \
  --output_dir checkpoints/$model_name \
  --model_name_or_path Qwen/Qwen3-0.6B \
  --num_vectors 1 \
  --pooling last_token \
  --add_compression_tokens False \
  --use_embed_loss True \
  --use_gen_loss False \
  --use_first_loss False \
  --use_ranknet_loss False \
  --data_path $data_path \
  --bf16 \
  --tf32 True \
  --per_device_train_batch_size 64 \
  --gradient_checkpointing \
  --gradient_accumulation_steps 1 \
  --learning_rate 2e-5 \
  --warmup_steps 300  \
  --lr_scheduler_type "linear" \
  --num_train_epochs 1 \
  --logging_strategy "steps" \
  --logging_steps 2 \
  --save_strategy "steps" \
  --save_steps 200 \
  --save_total_limit 2 \
  --overwrite_output_dir \
  --report_to "swanlab"

