# Goal Set Planning

This repo represents the supplementary code for the project "Ready, Set, Plan! Planning to Goal Sets Using
Generalized Bayesian Inference" submitted to the 7th Conference on Robotic Learning.

## Installation

### Create virtual environment & install requirements
We recommend the use of a python virtual environment for ease of installation. If you did not get this code via a git clone operation, you will need to create an empty git repository here for the installation to work:

```bash
cd goal-set-planning-code
git init
```

After cloning this repo (or creating an empty repo), create a virtual environment as follows:

```bash
cd goal-set-planning-code
python -m venv rsp_env
source ./rsp_env/bin/activate
pip install -r requirements.txt
pip install -e .
```

## Generate figures

### Qualitative

To generate the qualitative figures for all experiments, execute the `planar_nav_qualitative.py` script with the desired scene and configuration as follows:

```bash
cd goal-set-planning-code
python ./scripts/exp/planar_nav_qualitative.py --scene ./config/exp/scenes/circles_gaussian.yml --config ./config/exp/planar_nav_qual.yml
```

The scene can be changed as necessary to generate figures for other environments. Output visualizations can then be found at `./output/exp/qualitative/<exp>/`

### Quantitative

To generate metrics, first, execute the `planar_nav_run_all.py` script, followed by the `planar_nav_compute_metrics.py` script with the desired scene and configuration as follows:

```bash
cd goal-set-planning-code
python ./scripts/exp/planar_nav_run_all.py
python ./scripts/exp/planar_nav_qualitative.py
```

The output for each scene/experiment can then be found at `./output/exp/quantitative/<exp>/`

## References

Some two sample statistics in the file `distributions/distances.py` are adapted from the following repository: https://github.com/josipd/torch-two-sample
