import numpy as np
from tracikpy import TracIKSolver

ROBOT_FILE = "/home/researcher/code/readysetplan/stochastic_control/src/storm/content/assets/urdf/franka_description/franka_panda.urdf"


def get_ik_soln(ee_pos, ee_rot, q_init):
    ee_pose = np.eye(4)
    ee_pose[:3, :3] = ee_rot.view(3, 3).cpu().numpy()
    ee_pose[:3, 3] = ee_pos.cpu().numpy()

    ik_solver = TracIKSolver(
        ROBOT_FILE,
        "panda_link0",
        "panda_hand",
    )
    qout = ik_solver.ik(ee_pose, qinit=q_init.cpu().numpy())
    return qout
