import h5py
import numpy as np


def read_acronym_grasps(grasp_file):
    with h5py.File(grasp_file, "r") as grasps:
        grasp_tfs = grasps['grasps/transforms'][...]
        qualities = grasps['grasps/qualities/flex/object_in_gripper'][...]

    return grasp_tfs, qualities


def pick_successful_grasps(grasp_file, num=1):
    grasps, qualities = read_acronym_grasps(grasp_file)

    success_grasps, = np.nonzero(qualities)
    idx = np.random.choice(success_grasps, num)

    return grasps[idx, :, :]
