import csv

# File paths
input_file = './data/disease-sympton.txt'
output_file = './data/disease_symptom_pairs.txt'

# Function to process the input file and generate pairs
def process_disease_symptom_file(input_file, output_file):
    with open(input_file, 'r') as infile, open(output_file, 'w', newline='') as outfile:
        reader = csv.reader(infile)
        writer = csv.writer(outfile)
        
        for row in reader:
            disease = row[0].strip()
            symptoms = [symptom.strip().replace('_', ' ') for symptom in row[1:] if symptom.strip()]
            
            for symptom in symptoms:
                writer.writerow([disease, symptom])

# Process the file
process_disease_symptom_file(input_file, output_file)
print(f"Disease-symptom pairs have been written to {output_file}")