# Machine Learning Blog | ML@CMU | Carnegie Mellon University

_**TL;DR:** Landmines pose a persistent threat and hinder development in over 70 war-affected countries. Humanitarian demining aims to clear contaminated areas, but progress is slow: at the current pace, it will take 1,100 years to fully demine the planet. In close collaboration with the UN and local NGOs, we co-develop an interpretable predictive tool for landmine contamination to identify hazardous clusters under geographic and budget constraints, experimentally reducing false alarms and clearance time by half. The system is being tested in Afghanistan and Colombia, where it has already led to the discovery of new landmines._

* * *

Anti-personnel landmines are explosive devices hidden in the ground designed to explode by proximity or contact and with the capacity to kill, disable or cause harm to humans (Fig. 1). The mere threat of landmine contamination in a territory not only endangers the physical well-being of affected populations but also results in a loss of [forest](https://link.springer.com/article/10.1007/s10113-021-01770-6) areas, reduction of [productive](https://web.mit.edu/demining/assignments/farming_minefields-uwa.pdf) [land](https://www.sciencedirect.com/science/article/abs/pii/B9780128012314000136), exacerbation of [social vulnerability](https://www.sciencedirect.com/science/article/pii/S2212420915301576), delay of infrastructure [development](https://journals.sagepub.com/doi/10.1177/15423166211068324?icid=int.sj-abstract.citing-articles.1), and damage of natural, physical, and social [capital](https://www.tandfonline.com/doi/full/10.1080/17467586.2020.1853192#:~:text=Linking%20the%20anti%2Dpersonnel%20landmines,productivity%2C%20income%2C%20and%20the%20quality). Due to such negative consequences, in 1997 most countries signed the Ottawa Treaty committing themselves to stop the manufacture, commercialization, and use of landmines. Likewise, the countries that had historically used these explosive devices during armed conflicts undertook to clear the contaminated territories. Despite ongoing efforts, landmines continue to be used in conflicts worldwide, posing a persistent threat to humanity and hindering the development of war-affected communities in over [70 countries](https://news.un.org/en/story/2023/04/1135252), impacting more than 60 million people and causing nearly 7,000 casualties every year.


Humanitarian mine action operations seek to clear conflict-affected regions of remaining landmines so that communities can safely reland their territories. However, demining operations are laborious and costly due to vast areas that need surveying and the limited monetary and human resources available: **at the current rate, it will take about 1,100 years to clear the planet of all remaining landmines** , underscoring the urgent need for innovative evidence-based approaches to make demining operations more efficient and safer. In this context, we co-designed the **RELand** system (Risk Estimation of Landmines), in partnership with the United Nations Mine Action Service and local demining organizations, to efficiently identify hazardous areas for priority landmine clearance. RELand is currently being tested in Colombia, where it has already led to the discovery of three new landmines in a newly prioritized area, potentially saving civilian lives. We have also tailored and deployed the system in [Afghanistan](https://commons.lib.jmu.edu/cisr-journal/vol28/iss3/7/), and we are preparing for its deployment in war-torn territories globally, in partnership with UNMAS and UNOPS.

## [RELand](https://arxiv.org/pdf/2311.03115): Risk Estimation of Landmines via Interpretable Invariant Risk Minimization

RELand is a holistic pipeline to identify priority hazard areas to support non-technical surveys in humanitarian demining operations. Theses initial surveys are currently carried out by human experts who evaluate the possible presence of landmines based on available information and that provided by the residents. Since landmines are not used randomly but under [war logic](https://centrodememoriahistorica.gov.co/la-guerra-escondida-minas-antipersonal-y-remanentes-explosivos-en-colombia/), Machine Learning can potentially help with these surveys by analyzing historical events and their correlation to relevant features. However, identifying landmine contamination has been scarcely studied in the literature, and poses three main challenges: noisy labels, geographic dependence, and sparse predicted risk scores. We address the challenges of landmine risk estimation by enhancing existing datasets with rich relevant features, constructing a novel, robust, and interpretable ML model that outperforms standard and new baselines, and identifying cohesive hazard clusters under geographic and budgetary constraints. Finally, the results are delivered through a web application developed with key mine action stakeholders. The major components of RELand are illustrated in Fig. 2. Notably, our approach is the first public pipeline of its kind that can be easily adapted for use in demining workflows globally.

The first component of the system, _Dataset Enhancement_ , integrates different sources of information to construct a dataset for landmine presence with rich relevant features based on geographic information, socio-demographic variables, remnants of war indicators, and historical landmine events. We introduce several new features which prove useful to identify hazard areas and to rule out false alarms. We also argue how labels should be assigned to predict the results of humanitarian demining operations, rectifying the definition of labels used in previous literature.

For the _Risk Modeling_ component, we designed a novel interpretable deep learning tabular model extending [TabNet](https://arxiv.org/abs/1908.07442). We propose to minimize the [Invariant Risk Minimization](https://arxiv.org/abs/1907.02893) (IRM), which enables the model to be robust to distribution shifts and invariant to diverse deployment environments. Intuitively, we define an “easy” environment as one where landmines are found close to past events or grid cells with no historical landmines nearby have indeed negative labels. In contrast, a “hard” environment is one where despite there being some historical events there are no new landmines (and resources are going to be used inefficiently) or new landmines found far away from previous events (and likely missed by baseline methods leading to a latent risk to humans). Formally, let us denote an environment by \\(e = (X^e, Y^e)\\) and let \\(w\\) be a dummy scalar classifier. Then the IRM loss is composed by an ERM cross-entropy term that encourages prediction accuracy, and a regularization term that forces \\(f_\theta\\) to be simultaneously optimal across all environments \\(E\\). Our landmine risk estimator \\(f_{\theta}(X)\\) is penalized for applying the distance-existence rule in “easy” environments to “hard” ones, and therefore generalizes well on both environments.

$$IRM(\theta) = \min_{\theta} \sum\limits_{e \in E} \ell_{\text{CE}}(f_\theta(X^e), Y^e) + \lambda \cdot ||\nabla_{w|w=1} \ \ell_{\text{CE}}(w( f_\theta(X^e)), Y^e)||^2$$

However, our partner demining organizations quickly emphasized the need for interpretable models, as they must explain to communities why certain areas are prioritized for clearance or not. Therefore, as the first step towards the interpretation of landmine risk estimators, we utilize [SparseMax](https://arxiv.org/abs/1602.02068) layers to generate global feature importance for our model. SparseMax (SM) is an activation function that normalizes the input vector to sparse probabilities (like a LASSO regularization), and is shown at the top of Fig. 3. Finally, we leverage the sequential design in TabNet to form decision blocks that are summed together and passed into an aggregation FC layer as the final prediction. This sequential design resembles additive modeling in [Gradient Boosting Machines](https://www.researchgate.net/publication/2424824_Greedy_Function_Approximation_A_Gradient_Boosting_Machine) and [ResNet](https://arxiv.org/abs/1512.03385) skip connection [mechanism](https://arxiv.org/abs/1605.06431). Initial blocks capture the main correlation in the dataset, and the following blocks can use the rest of the features to learn the residuals to fit the function better. Our final architecthure is show in Figure 3.

To validate the proposed system, we simulate different scenarios in which the RELand system could be deployed in mine clearance operations using real data from Colombia. We use a [block cross-validation](https://nsojournals.onlinelibrary.wiley.com/doi/10.1111/ecog.02881) approach, where the hold-out set corresponds to all cells in a municipality, to account for the geographical nature of current demining operations. In addition, since false negatives represent a higher cost in terms of human lives, we use the Height and Reverse Height (rHeight) [metrics](https://dspace.mit.edu/handle/1721.1/55352) of how well a ranking is generated, in the sense that positive cells should be ranked higher than negative cells. Intuitively, models with better predictions for top-ranked regions can speed-up land clearing operations. Given a predicted risk score, Height refers to the number of positive cells ranked below a negative cell, and rHeight is the number of negative cells ranked above a positive one. An ideal classifier minimizes both of these metrics and perfectly rank positive cells above negative cells. Formally,

$$ Height(X_n) = \sum\limits_{i = 1}^{P}\mathbb{1}(\widehat{f}(X_\text{p})_i \leq \widehat{f}(X_\text{n})), $$ 

$$rHeight(X_p) = \sum\limits_{j = 1}^{N}\mathbb{1}(\widehat{f}(X_\text{p}) \leq \widehat{f}(X_\text{n})_j) $$

where \\(P\\) and \\(N\\) are the total counts of positive and negative labels, respectively, and \\(\widehat{f}(X_\text{p}\\)) \\((\widehat{f}(X_\text{n}))\\) is the predicted probability when the ground truth of \\(X_i\\) \\((X_j)\\) is positive (negative).

Table 1 presents the result of the experimental validation comparing the proposed methodology with current practices, focusing mainly on historical landmine reports, and two previous ML models proposed in the literature. RELand consistently outperforms the benchmark models on all relevant metrics. Furthermore, Table 1 shows that the proposed method reduces the mean-rHeight by almost half compared to previous approaches. Intuitively, if we were to sequentially clear a region according to the generated risk score ranking, this metric tells us the average number of negative cells we would need to visit before the region is completely cleared. This measures how efficiently we could demine a geographic region of interest: **RELand reduces the false alarms and the time required for landmine clearance by half.**

Model| ROC (↑)| PR (↑)| mean-Height (↓)| mean-rHeight (↓)  
---|---|---|---|---  
LR-single (current)| 86.35 (11.54)| 17.07 (10.76)| 3.06 (3.19)| 226.79 (211.23)  
LR-geo ([2019](https://ieeexplore.ieee.org/document/8765724), [2016](https://www.sciencedirect.com/science/article/abs/pii/S0143622815300114#:~:text=In%20other%20words%2C%20the%20spatial,the%20delineation%20of%20predicted%20risk.))| 67.62 (18.58)| 5.37 (8.00)| 8.09 (6.93)| 573.36 (440.71)  
SVM-geo ([2019](https://ieeexplore.ieee.org/document/8765724))| 48.61 (18.09)| 1.73 (1.82)| 15.26 (15.66)| 821.26 (729.12)  
**RELand (ours)**| **92.90 (4.43)**| **29.03 (22.11)**| **2.17 (2.48)**| **132.03 (133.50)**  
Table1 . Validation results in Colombia. Each entry is the mean (std) performance on validation folds following the block cross-validation rule. RELand is our interpretable IRM model. Full experimental results and ablation studies are available in our [paper](https://dl.acm.org/doi/10.1145/3648437).

## Hazard Cluster Identification as a Quadratic Knapsack Problem

Building a reliable prediction model to estimate landmine contamination risk is a crucial first step in data-driven prioritization of land clearance operations. However, integrating the risk maps generated by machine learning models into demining workflows requires considering the additional geographical and budgetary constraints that mine action organizations face in their ground operations. For instance, demining organizations often operate under limited budgets, allowing them to clear only a fraction of the total area under study while also covering the costs associated with mobilizing equipment and teams across the region (e.g., metal detectors, sniffing dogs, and human deminers). Moreover, if multiple regions are to be demined, there must be a secure path connecting these regions to ensure the safe movement of such demining teams. Humanitarian demining organizations need to maximize the land released back to local communities while navigating these challenges.

We propose to find which cells to prioritize for mine clearance by using a [Quadratic Knapsack Problem](https://www.sciencedirect.com/science/article/pii/S0166218X06003878) (QKP), whose optimal solution naturally results in the identification of cohesive hazard clusters due to rewarding the program for prioritizing nearby grid cells. Formally, we use the risk scores \\(r_i\\) estimated by our trained deep learning model to compute proxies for the benefit of demining candidate grid cell \\(i\\) with centroid \\((x_i,y_i)\\). Then, define the reward matrix \\(U\\) that captures the (additional) benefit of prioritizing both grid cells \\(i\\) and \\(j\\) as

$$u_{ij} = \sqrt{r_i r_j}\exp\left(-\lambda ||s_i – s_j||_{h}\right),$$

where \\(||\cdot||_{h}\\) is the standard Haversine distance, and \\(\lambda\\) controls for the exponential decay of the spatial distance between two locations \\(s_i = (x_i, y_i)\\) and \\(s_j = (x_j, y_j)\\). For example, selecting a grid cell \\(i\\) for mine clearance results in a direct benefit of \\(u_{ii} = r_i\\). Note that, in our formulation, riskier cells yield greater rewards. This results in the following binary QKP with variables \\(z_i \in \\{0,1\\}\\), for \\(i\in [n]\\), which indicate if a grid cell \\(i\\) is selected for demining. Then, the total reward is given by \\(z^{T}Uz\\), which is maximized subject to a given budget \\(C \in \mathbb{R}_{+}\\) and demining costs \\(w_i\\):

$$ \max_{z \in \mathbb{R}^n} ~ z^{T}Uz $$

$$s.t. \quad \sum_{i=1}^n w_i z_i \leq C, \quad z_i \in \\{0, 1\\} \quad \forall i \in [n].$$

Our approach rewards for geographic cohesion, ultimately finding more useful hazard clusters than a greedy solution that prioritizes the \\(C\\) grid cells with the largest estimated risk scores (Fig. 4). Moreover, our approach also incorporates realistic budget constraints, unlike standard spatial statistical approaches for geographic clustering such as Moran Local I and LISA.

## Tangible Impact of RELand

We are currently conducting a field study in Colombia, in partnership with the United Nations Mine Action Service and the Colombian Campaign to Ban Landmines, in two municipalities recently selected for humanitarian demining that have not been previously surveyed. We applied RELand to these regions to (i) build the enhanced dataset with rich geographic features, (ii) generate landmine contamination risk estimates by using the trained DL model, and (iii) use the predicted risk scores to identify priority hazard clusters with the QKP formulation. We worked together with the field teams of our partner NGO in Colombia to validate the hazard clusters identified by the system and to create an initial demining plan in the assigned regions. Crucially, the proposed methodology (Fig. 4c) identifies useful cohesive hazard clusters under realistic budgetary constraints. These hazard regions are more useful for demining prioritization than the sparse raw risk scores (Fig. 4a) and the greedy risk clusters (Fig. 4b), which lead to excessive mobilization of demining teams and equipment. Overall, the risk maps generated are in line with what is expected by human experts in humanitarian demining in Colombia. To date, three landmines have been found in one priority area, saving human lives. Moreover, in collaboration with UNOPS and MAPA, we have tailored and deployed the system in [Afghanistan](https://commons.lib.jmu.edu/cisr-journal/vol28/iss3/7/), identifying 81 hazardous areas for prioritized demining interventions, positively impacting over 4 million people across the country.

We expect to have the full results of our demining field tests within 6 months to provide a real-world validation of RELand’s capabilities in ground operations. Based on the initial positive feedback, we believe the system can support critical parts of the initial planning of humanitarian mine action, making demining operations more efficient and safer. We are actively working with UNMAS, UNOPS, and local NGOs to refine the system in its three components and prepare it for deployment in war-torn territories globally.