BENCH = 'all'
TEST_SIZE = .25
RANDOM_STATE = 42

N_ESTIMATORS = 100 #RF (https://github.com/Not-Diamond/RoRF/blob/main/run_trainer.sh)
MAX_DEPTH = 20 #RF (https://github.com/Not-Diamond/RoRF/blob/main/run_trainer.sh)

LAMB = [.01, .1, .3, .5, .7, .9, .99]

MAX_LENGTH = 512 #BERT
BATCH_SIZE = 8 #BERT
BERT_NAME = "roberta-base"

LARGE_MODEL = 'Qwen/Qwen2.5-72B-Instruct' #MF #'Qwen/Qwen2.5-72B-Instruct'
SMALL_MODEL = 'Qwen/Qwen2.5-7B-Instruct' #MF

BENCHMARKS = {'bbh':['leaderboard_bbh_boolean_expressions',
                     'leaderboard_bbh_causal_judgement',
                     'leaderboard_bbh_date_understanding',
                     'leaderboard_bbh_disambiguation_qa',
                     'leaderboard_bbh_formal_fallacies',
                     'leaderboard_bbh_geometric_shapes',
                     'leaderboard_bbh_hyperbaton',
                     'leaderboard_bbh_logical_deduction_five_objects',
                     'leaderboard_bbh_logical_deduction_seven_objects',
                     'leaderboard_bbh_logical_deduction_three_objects',
                     'leaderboard_bbh_movie_recommendation',
                     'leaderboard_bbh_navigate',
                     'leaderboard_bbh_object_counting',
                     'leaderboard_bbh_penguins_in_a_table',
                     'leaderboard_bbh_reasoning_about_colored_objects',
                     'leaderboard_bbh_ruin_names',
                     'leaderboard_bbh_salient_translation_error_detection',
                     'leaderboard_bbh_snarks',
                     'leaderboard_bbh_sports_understanding',
                     'leaderboard_bbh_temporal_sequences',
                     'leaderboard_bbh_tracking_shuffled_objects_five_objects',
                     'leaderboard_bbh_tracking_shuffled_objects_seven_objects',
                     'leaderboard_bbh_tracking_shuffled_objects_three_objects',
                     'leaderboard_bbh_web_of_lies'],
              'gpqa':['leaderboard_gpqa_diamond',
                     'leaderboard_gpqa_extended',
                     'leaderboard_gpqa_main'],
              'ifeval':['leaderboard_ifeval'],
              'math':['leaderboard_math_algebra_hard',
                     'leaderboard_math_counting_and_prob_hard',
                     'leaderboard_math_geometry_hard',
                     'leaderboard_math_intermediate_algebra_hard',
                     'leaderboard_math_num_theory_hard',
                     'leaderboard_math_prealgebra_hard',
                     'leaderboard_math_precalculus_hard'],
              'mmlu_pro':['leaderboard_mmlu_pro'],
              'musr':['leaderboard_musr_murder_mysteries',
                      'leaderboard_musr_object_placements',
                      'leaderboard_musr_team_allocation']}
BENCHMARKS['all'] = BENCHMARKS['bbh']+BENCHMARKS['gpqa']+BENCHMARKS['math']+BENCHMARKS['mmlu_pro']+BENCHMARKS['musr']

SCENARIOS = ['leaderboard_bbh_boolean_expressions',
             'leaderboard_bbh_causal_judgement',
             'leaderboard_bbh_date_understanding',
             'leaderboard_bbh_disambiguation_qa',
             'leaderboard_bbh_formal_fallacies',
             'leaderboard_bbh_geometric_shapes',
             'leaderboard_bbh_hyperbaton',
             'leaderboard_bbh_logical_deduction_five_objects',
             'leaderboard_bbh_logical_deduction_seven_objects',
             'leaderboard_bbh_logical_deduction_three_objects',
             'leaderboard_bbh_movie_recommendation',
             'leaderboard_bbh_navigate',
             'leaderboard_bbh_object_counting',
             'leaderboard_bbh_penguins_in_a_table',
             'leaderboard_bbh_reasoning_about_colored_objects',
             'leaderboard_bbh_ruin_names',
             'leaderboard_bbh_salient_translation_error_detection',
             'leaderboard_bbh_snarks',
             'leaderboard_bbh_sports_understanding',
             'leaderboard_bbh_temporal_sequences',
             'leaderboard_bbh_tracking_shuffled_objects_five_objects',
             'leaderboard_bbh_tracking_shuffled_objects_seven_objects',
             'leaderboard_bbh_tracking_shuffled_objects_three_objects',
             'leaderboard_bbh_web_of_lies','leaderboard_gpqa_diamond',
             'leaderboard_gpqa_extended',
             'leaderboard_gpqa_main','leaderboard_ifeval','leaderboard_math_algebra_hard',
             'leaderboard_math_counting_and_prob_hard',
             'leaderboard_math_geometry_hard',
             'leaderboard_math_intermediate_algebra_hard',
             'leaderboard_math_num_theory_hard',
             'leaderboard_math_prealgebra_hard',
             'leaderboard_math_precalculus_hard','leaderboard_mmlu_pro','leaderboard_musr_murder_mysteries',
             'leaderboard_musr_object_placements',
             'leaderboard_musr_team_allocation']


MODELS = ['open-llm-leaderboard/NousResearch__Nous-Hermes-2-Mixtral-8x7B-DPO-details',
          'open-llm-leaderboard/01-ai__Yi-34B-Chat-details',
          'open-llm-leaderboard/Qwen__QwQ-32B-Preview-details',
          'open-llm-leaderboard/Qwen__Qwen2-72B-Instruct-details',
          'open-llm-leaderboard/Qwen__Qwen2.5-7B-Instruct-details',
          'open-llm-leaderboard/Qwen__Qwen2.5-72B-Instruct-details',
          'open-llm-leaderboard/alpindale__WizardLM-2-8x22B-details',
          'open-llm-leaderboard/deepseek-ai__deepseek-llm-67b-chat-details',
          'open-llm-leaderboard/google__gemma-2-27b-it-details',
          'open-llm-leaderboard/google__gemma-2-9b-it-details',
          'open-llm-leaderboard/google__gemma-2b-it-details',
          'open-llm-leaderboard/meta-llama__Llama-2-13b-chat-hf-details',
          'open-llm-leaderboard/meta-llama__Meta-Llama-3.1-70B-Instruct-details',
          'open-llm-leaderboard/meta-llama__Meta-Llama-3.1-8B-Instruct-details',
          'open-llm-leaderboard/mistralai__Mistral-7B-Instruct-v0.1-details', 
          'open-llm-leaderboard/mistralai__Mistral-7B-Instruct-v0.2-details',
          'open-llm-leaderboard/mistralai__Mistral-7B-Instruct-v0.3-details',
          #'open-llm-leaderboard/mistralai__Mixtral-8x22B-Instruct-v0.1-details', not avail
          'open-llm-leaderboard/mistralai__Mixtral-8x7B-Instruct-v0.1-details',
          'open-llm-leaderboard/nvidia__Llama-3.1-Nemotron-70B-Instruct-HF-details',
          'open-llm-leaderboard/upstage__SOLAR-10.7B-Instruct-v1.0-details']

COSTS = {'NousResearch/Nous-Hermes-2-Mixtral-8x7B-DPO':.6,
         '01-ai/Yi-34B-Chat':.8,
         'Qwen/QwQ-32B-Preview':1.2,
         'Qwen/Qwen2-72B-Instruct':.9,
         'Qwen/Qwen2.5-7B-Instruct':.3,
         'Qwen/Qwen2.5-72B-Instruct':1.2,
         'alpindale/WizardLM-2-8x22B':1.2,
         'deepseek-ai/deepseek-llm-67b-chat':.9,
         'google/gemma-2-27b-it':.8,
         'google/gemma-2-9b-it':.3,
         'google/gemma-2b-it':.1,
         'meta-llama/Llama-2-13b-chat-hf':.3,
         'meta-llama/Meta-Llama-3.1-70B-Instruct':.9,
         'meta-llama/Meta-Llama-3.1-8B-Instruct':.2,
         'mistralai/Mistral-7B-Instruct-v0.1':.2,
         'mistralai/Mistral-7B-Instruct-v0.2':.2,
         'mistralai/Mistral-7B-Instruct-v0.3':.2,
         'mistralai/Mixtral-8x7B-Instruct-v0.1':.6,
         'nvidia/Llama-3.1-Nemotron-70B-Instruct-HF':.9,
         'upstage/SOLAR-10.7B-Instruct-v1.0':.3}