# TADIS: Steering Models for Deep-Thinking about Demonstration Examples

## Method
Instruction tuning has been demonstrated that could significantly improve the zero-shot generalization capability to unseen tasks by a huge margin. By incorporating additional context (e.g., task definition, examples) during the fine-tuning process, Large Language Models (LLMs) achieved much higher performance than before. However, recent work reported that delusive task examples can achieve almost the same performance as correct task examples, indicating the input-label correspondence is much less important than previously thought. Intrigued by this counter-intuitive observation, we suspect models have the same illusion of competence as humans. Therefore, we propose a novel method called (TADIS) that steers LLMs for ``Deep-Thinking" about provided examples instead of mere seeing. To break the illusion of competence of models, we first force the model to judge the correctness of shown examples. Then, using the previous thinking about examples as conditions to elicit models for a better answer. Our experimental results show that TADIS consistently outperforms competitive baselines on in-domain and out-domain tasks (improving 2.789 and 4.026 average ROUGLE-L on held-out and held-in datasets, respectively). Even with generated examples (not all thinking labels are correct), TADIS can still significantly improve performance in zero-shot and few-shot settings which indicates our method can be adopted on a large scale to improve the instruction following capabilities of models without any manual labor. Moreover, we construct three thinking labels with different model sizes and find that small models learn the format of TADIS but larger models can be steered for ``Deep-Thinking".




## Requirements
Make sure you have Python>=3.8 installed on your machine.
pip install torch==1.8.2+cu111 torchtext==0.9.2 -f https://download.pytorch.org/whl/lts/1.8/torch_lts.html




## Quick Start
For a quick start, you can directly run TADIS

# TADIS
```shell
bash ./shell/TADIS_format_train.sh
```
# SuperNI
```shell
bash ./shell/SuperNI_format_train.sh
```

