function wordBox(x, y, word, font, fontSize){


    // SIGGRAPH DATA

    // get word from text file
    for (var i=0; i<word.length; i++){
        if (word.substring(i, i+1) == " "){
            this.word = word.substring(0, i);
            break;
        }
    }

    word = word.replace(this.word + " ", "");
    word = word.replace("[", "");
   

    this.frequency = [];
    var b = 0;

    // get array of frequencies from text file
    while (word.length>1){
        this.frequency[b] = parseFloat(word);
        word = word.replace(this.frequency[b], "");
        word = word.replace(", " , "");
        b++;
    }    

    this.smallest = Math.min(...this.frequency);
    this.largest = Math.max(...this.frequency);
 

    // get variance of frequency for this word
    this.variance = variance(this.frequency)
    if (this.variance > 75)
        this.variance = 75;


    this.startFont = 50;



    var options = {
        friction: 0.001,
        restitution: 0,
    };
    
    // get required size for the body
    this.width = getTextWidth(this.word, this.startFont + "px arial"); 
    this.height = this.startFont;


    var maxWidth = getTextWidth(this.word, font); 
    var maxHeight = fontSize;
    
    // create corresponding Matter body for each word
    this.body = Bodies.rectangle(x, y, this.width, this.height, options);

    World.add(world, this.body);



    var colorValue = 100 - (100 - (this.variance*35)/0.000025) + 65  ;  // siggraph color variance
 
    
    // add word texture to the body 
    this.graphics = createGraphics(maxWidth, maxHeight);
    this.graphics.textSize(fontSize);
    this.graphics.textFont('impact')
    this.graphics.textAlign(CENTER);
    this.graphics.colorMode(HSB, 100);
    colorMode(HSB, 100);
    this.color = color(colorValue, 70, 80);
    this.graphics.fill(this.color);
    this.graphics.text(this.word, maxWidth/2, maxHeight/1.2);


    this.step = [];
    this.step[0] = 0;


    this.maxSize = maxHeight*maxWidth;
    this.minSize = 100;
    this.size = this.body.area;



    this.show = function(){

        var pos = this.body.position;
        var angle = this.body.angle;

        push();

        // remove word if never appears at this point in time and put back if it returns
        if (this.frequency[slider2.value()] == 0){
            this.graphics.clear();
            this.cleared = true;
        }
        else if (this.cleared == true){
            this.cleared = false;
            this.graphics = createGraphics(maxWidth, maxHeight);
            this.graphics.textSize(fontSize);
            this.graphics.textFont('impact')
            this.graphics.textAlign(CENTER);
            this.graphics.fill(this.color);
            this.graphics.text(this.word, maxWidth/2, maxHeight/1.2);
        } 

        slider2.changed(scaler);

        
        // apply force to push words to center
        Body.applyForce(this.body, {x: pos.x, y: pos.y}, {
            x: this.frequency[slider2.value()]*(-pos.x/250), 
            y: this.frequency[slider2.value()]*(-pos.y/250)
        });

        // damping forces
        this.velocity*=0.9;
        this.angularVelocity*=0.9;

        translate(pos.x, pos.y);
        rotate(angle);
        
        noStroke();
        textureMode(NORMAL);
        texture(this.graphics);
        rect(0,0,this.width,this.height);
        pop();

    }

    scaler = function(){
    
        z++;
        current[z] = slider2.value();

        for (var i = 0; i<words.length; i++){
            words[i].step[z] = 0;
        }

    }




}
