# Attention Cluster Simulation and Visualization Toolkit

*⚠️ Full code, documentation and usage guide coming soon. Basic setup below.*
## 📦 Requirements

### Install with:
pip install -r requirements.txt


## 🚀 Quick Start
### 1. Run simulation

```commandline
python simulate.py --data_path objects/image4096.pt --attn_type global --num_layers 20 --save_pt_path outputs/gb/imgs --save_png_path figures/gb/imgs
```

### 2. Visualize mask from clusters

```commandline
python visualize_mask.py  --data_path outputs/gb/imgs/clusters_iter_21.pt --clusters [[2]] --save_path figures/gb/imgs --image_size 64 64
```


## 📁 Project Structure
````
project/
├── attention_modules.py     # Attention modules. (add custom modules here)
├── configs.py               # Config classes (add custom configs here)
├── util_funcs.py            # Utility functions
├── simulate.py              # Main simulation script
├── visualize_mask.py        # cluster mask visualization (for image)
├── requirements.txt         # Python dependencies
├── README.md                # This documentation
├── objects/                 # Input data directory
│   └── diabetes1024.pt            # Example input tensor
├── outputs/                 # Simulation outputs.pt
└── figures/                 # Visualization results
````

## 🔧 simulate.py - Attention Simulation
### basic usage

```commandline
python simulate.py --dataset diabetes --attn_type longformer --device cuda  --save_pt_path outputs/lf/diabetes --save_png_path figures/lf/diabetes
```
### Parameters

```text
Required:

    --dataset: ['diabetes', 'heart', 'image', 'generated'] to use defaults
               or --data_path <Path to input data tensor (.pt file)>
    
    --attention_type: Type of attention ['global', 'local', 'longformer'] or a custom module
                      specified in attention_modules.py
    
To see full parameters run: python simulate.py -h

```

## 🎨 visualize_mask.py - Cluster Visualization (for images only)
### Usage

```text
python visualize_mask.py  --data_path <path> --clusters <nestedlist> [options]


Valid --clusters examples:

"[[3,2,4,2]]" - Single batch, 4 heads with 3,2,4,2 clusters

"[[3,2],[4,3]]" - Two batches, 2 heads each with different clusters

"[[2],[3],[4]]" - Three batches, 1 head each with 2,3,4 clusters

```

