# Graph-based-DG

## Set Environment
```shell
conda env create -f GDG.yaml
pip -r install requirments.txt


# install dgl package
pip install  dgl -f https://data.dgl.ai/wheels/cu113/repo.html
pip install  dglgo -f https://data.dgl.ai/wheels-test/repo.html
```

## CUB-DG
### Dataset
You can download the **CUB-DG** dataset at [here](https://github.com/mswzeus/GVRT.git)!


### How to Train?
```shell
./train.sh [LOG_DIR_PATH] [arg_OPTIONS]
```
- If you want to train other algorithms, you should edit the `train.sh` file.
   

### How to Evaluate?
```shell
./eval.sh [LOG_DIR_PATH] [env0_CHECKPOINT] [env1_CHECKPOINT] [env2_CHECKPOINT] [env3_CHECKPOINT]
```
- If you want to evaluate other algorithms, you should edit the `eval.sh` file.

## Domainbed
We modified the DomainBed repo to utilize natural language.   
You have to download Domainbed dataset first.
For more information, please see the original repo.

If you want to train/evaluate our model on Domainbed benchmark, you should move the directory before training.
```shell
cd Domainbed_GDG
```

### How to Train?
You can train our model for each dataset using a shell script named `[DATA_SET].sh`
```shell
./[DATA_SET].sh [algorithm] [LOG_DIR_PATH] [TRIAL_SEED] [HPARAM_SEED] [ARGS]
```

If you want to train our model in Few-shot setting, you should use the command below.   
(When you want to tran our model on DomainNet dataset, you should uncomment in `FSDG.sh`)
```shell
./FSDG.sh [algorithm] [LOG_DIR_PATH] [DATA_SET] [TRIAL_SEED] [HPARAM_SEED] [ARGS]
```

### How to Evaluate?
```shell
python -m domainbed.scripts.collect_results\
 --input_dir=/workspace/Graph-based-DG/DomainBed_GDG/train_output/[DATA_SET]/[LOG_DIR_PATH]
```

