from dotenv import load_dotenv
from openai import AzureOpenAI
from azure.identity import DefaultAzureCredential, get_bearer_token_provider
import json
import re
import os
import subprocess
import io
import sys
from openai import OpenAI
from typing_extensions import override
from openai import AssistantEventHandler
from generation_models import message_construct_func, GPT_response, count_total_tokens
import copy
import argparse
from datasets import load_dataset
import random
import time
import numpy as np
import ast
from prompt import *
from argparse import ArgumentParser

def extract_code(text):
    # Regular expression to match code blocks enclosed in triple backticks
    code_block_pattern = re.compile(r'```python\n(.*?)\n```', re.DOTALL)

    # Find all matches in the text
    code_blocks = code_block_pattern.findall(text)

    # If no code blocks are found, try to find indented code blocks
    if not code_blocks:
        return []

    return code_blocks

def generate_random_integers(digit_num):
    # Calculate the range based on the number of digits
    min_value = 10 ** (digit_num - 1) - 1
    max_value = 10 ** digit_num - 1
    num = random.randint(min_value, max_value) * random.choice([-1, 1])
    while num == 0 or num == 1 or num == -1:
        num = random.randint(min_value, max_value) * random.choice([-1, 1])
    return num

def generated_num_list_func(digit_num_list):
    generated_num_list = [generate_random_integers(digit_num) for digit_num in digit_num_list]
    target_answer = generated_num_list[0]
    for generated_num in generated_num_list[1:]:
        target_answer *= generated_num
    '''
    while np.mod(target_answer, 10) == 0:
        generated_num_list = [generate_random_integers(digit_num) for digit_num in digit_num_list]
        target_answer = generated_num_list[0]
        for generated_num in generated_num_list[1:]:
            target_answer *= generated_num
    '''
    return generated_num_list, target_answer

def read_value_list(file_path):
    with open(file_path, 'r') as f:
        value_list = f.read()
    return ast.literal_eval(value_list)

def read_answer(file_path):
    with open(file_path, 'r') as f:
        answer = f.read()
    return int(answer)

def run_number_multiply(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
               AutoGen_prompt_concatenate, code_interpreter, Encourage_code_execution_interpreter, all_code_with_COT,
               all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num, method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first):
    print('\n' + '*'*30)
    print(f'Model_name: {model_name}, AutoGen_prompt_system_message: {AutoGen_prompt_system_message}, '
          f'AutoGen_prompt_concatenate: {AutoGen_prompt_concatenate}, code_interpreter: {code_interpreter}, Encourage_code_execution_interpreter: {Encourage_code_execution_interpreter}, '
          f'all_code_with_COT: {all_code_with_COT}, all_code_without_COT: {all_code_without_COT}, all_text: {all_text}, multi_turn_planning: {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}, '
          f'method_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n')

    total_test_num = 0
    num_with_code = 0
    num_without_code = 0
    time_with_code = 0
    time_without_code = 0

    if method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == False:
        base_save_code_dir = save_input_dir + f'/result_number_multiply_{model_name}_interpreter_{code_interpreter}_AutoGen_system_{AutoGen_prompt_system_message}_AutoGen_concatenate_{AutoGen_prompt_concatenate}_all_code_with_COT_{all_code_with_COT}_all_code_without_COT_{all_code_without_COT}_Encourage_code_execution_interpreter_{Encourage_code_execution_interpreter}_all_text_{all_text}_multi_turn_planning_{multi_turn_planning}_round_num_{multi_turn_planning_round_num}'
    elif method_9_all_text_all_code_summarizer == True and method_10_LLM_estimates_scores_first == False:
        base_save_code_dir = save_input_dir + f'/result_number_multiply_{model_name}_method_9_all_text_all_code_summarizer'
    elif method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == True:
        base_save_code_dir = save_input_dir + f'/result_number_multiply_{model_name}_method_10_LLM_estimates_scores_first'
    else:
        raise ValueError("method_9_all_text_all_code_summarizer and method_10_LLM_estimates_scores_first can't be both True")

    if not os.path.exists(base_save_code_dir):
        os.makedirs(base_save_code_dir)

    #for digit_num_list in [[1, 1], [2, 2], [1, 2, 2, 4], [4, 4], [3, 4], [1, 2, 4], [3, 3], [1, 3, 4], [5, 5], [6,6], [1, 1, 1, 1, 1, 1, 3]]:
    for digit_num_list in [[1, 2, 4], [1, 3, 4], [1, 2, 2, 4]]:
            dir_digit_name = f'digit'
            for digit_num in digit_num_list:
                dir_digit_name += f'_{digit_num}'

            dataset_base_dir = os.path.join(dataset_input_dir, f'{dir_digit_name}')
            save_code_dir_dir_digit_num = os.path.join(base_save_code_dir, f'{dir_digit_name}')
            if not os.path.exists(save_code_dir_dir_digit_num):
                os.makedirs(save_code_dir_dir_digit_num)

            for i in range(0, 25):
                with_code = False
                total_test_num += 1

                print(f'\n{dir_digit_name}, sample num: {i}')
                dataset_base_dir_sample = os.path.join(dataset_base_dir, f'sample_{i}')
                generated_num_list = read_value_list(dataset_base_dir_sample + f"/input_value_list.txt")
                target_answer = read_answer(dataset_base_dir_sample + f"/target_answer.txt")

                save_code_dir = os.path.join(save_code_dir_dir_digit_num, f'sample_{i}')
                if not os.path.exists(save_code_dir):
                    os.makedirs(save_code_dir)

                equation_prompt = f'{generated_num_list[0]}'
                for generated_num in generated_num_list[1:]:
                    equation_prompt += f'*{generated_num}'

                total_test_num += 1
                question = f'What is the result of ' + equation_prompt + '?'

                response_total_list = [];
                system_message = ""

                if method_9_all_text_all_code_summarizer == True and method_10_LLM_estimates_scores_first == False:
                    base_save_code_dir_all_text = save_input_dir + f'/result_number_multiply_{model_name}_interpreter_False_AutoGen_system_False_AutoGen_concatenate_False_all_code_with_COT_False_all_code_without_COT_False_Encourage_code_execution_interpreter_False_all_text_True_multi_turn_planning_True_round_num_{multi_turn_planning_round_num}'
                    base_save_code_dir_all_code = save_input_dir + f'/result_number_multiply_{model_name}_interpreter_False_AutoGen_system_False_AutoGen_concatenate_False_all_code_with_COT_False_all_code_without_COT_True_Encourage_code_execution_interpreter_False_all_text_False_multi_turn_planning_True_round_num_{multi_turn_planning_round_num}'
                    save_code_dir_all_text = os.path.join(base_save_code_dir_all_text, f"{dir_digit_name}/sample_{i}/")
                    save_code_dir_all_code = os.path.join(base_save_code_dir_all_code, f"{dir_digit_name}/sample_{i}/")
                    with open(save_code_dir_all_text + f"/response_code_1.txt", "r") as f:
                        response_all_text = f.read()
                    with open(save_code_dir_all_code + f"/response_code_1.txt", "r") as f:
                        response_all_code = f.read()
                    input_prompt = combined_agent_prompt + '###The input question is: \n' +question + f'\n\n'
                    input_prompt = input_prompt + f'\nThe response from Agent_1 is: {response_all_text}'

                    if os.path.exists(save_code_dir_all_text + f"/code_1_0.py"):
                        with open(save_code_dir_all_text + f"/extracted_answer_1.txt", "r") as f:
                            extracted_all_text = f.read()
                        input_prompt = input_prompt + f'\nThe execution result from the Agent_1 code is: {extracted_all_text}'

                    input_prompt = input_prompt + f'\n\nThe response from Agent_2 is: {response_all_code}'
                    if os.path.exists(save_code_dir_all_code + f"/code_1_0.py"):
                        with open(save_code_dir_all_code + f"/extracted_answer_1.txt", "r") as f:
                            extracted_all_code = f.read()
                        input_prompt = input_prompt + f'\nThe execution result from the Agent_2 code is: {extracted_all_code}'
                    input_prompt = input_prompt + f'\n\nNow you need to analyze the problem based on their answers and output final answer with the required format in the original question. Your analysis and answer:\n'

                    #print(f'\n#########input_prompt: \n{input_prompt}')
                    user_prompt_list = [input_prompt]

                elif method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == True:
                    user_prompt_list = [method_10_self_estimate_score_prompt + question]
                elif Encourage_code_execution_interpreter == True and code_interpreter == True and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                    user_prompt_list = [Encourage_code_execution_prompt_for_code_interpreter + question]
                elif AutoGen_prompt_system_message == True and AutoGen_prompt_concatenate == False and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                    system_message = AutoGen_prompt
                    user_prompt_list = [question]
                elif AutoGen_prompt_system_message == False and AutoGen_prompt_concatenate == True and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                    user_prompt_list = [AutoGen_prompt + question]
                elif AutoGen_prompt_system_message == False and AutoGen_prompt_concatenate == False and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                    user_prompt_list = [question]
                elif code_interpreter == False and all_code_with_COT == True and all_code_without_COT == False and all_text == False:
                    user_prompt_list = [with_COT_all_code_prompt_2 + question]
                elif code_interpreter == False and all_code_with_COT == False and all_code_without_COT == True and all_text == False:
                    user_prompt_list = [without_COT_all_code_prompt_1 + question]
                elif code_interpreter == False and all_code_with_COT == False and all_code_without_COT == False and all_text == True:
                    user_prompt_list = [text_output_prompt + question]
                with open(save_code_dir + f"/system_message.txt", "w") as f:
                    f.write(system_message)
                with open(save_code_dir + f"/target_answer.txt", "w") as f:
                    f.write(str(target_answer))

                if multi_turn_planning:
                    round_number = multi_turn_planning_round_num
                else:
                    round_number = 1

                execution_time_total = 0
                for round_index in range(round_number):
                    with open(save_code_dir + f"/input_prompt_{round_index + 1}.txt", "w") as f:
                        f.write(user_prompt_list[round_index])

                    print(f'Round {round_index + 1}')
                    start_time = time.time()

                    # 15000 tokens limit for gpt-3.5-turbo
                    if count_total_tokens(user_prompt_list, response_total_list) > 15000 and model_name in [
                        'gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
                        break

                    response_code = GPT_response("", user_prompt_list[0], model_name=model_name,
                                                 code_interpreter=code_interpreter, user_prompt_list=user_prompt_list,
                                                 response_total_list=response_total_list)
                    code_block_list = extract_code(response_code)
                    for index_code, code_string in enumerate(code_block_list):
                        with open(save_code_dir + f"/code_{round_index + 1}_{index_code}.txt", "w") as f:
                            f.write(code_string)
                    with open(save_code_dir + f"/response_code_{round_index + 1}.txt", "w") as f:
                        f.write(response_code)
                    if 'TERMINATE' in response_code:
                        print(f'Terminate in round {round_index + 1}. Completed!')
                        end_time = time.time()
                        execution_time = end_time - start_time
                        execution_time_total += execution_time
                        with open(save_code_dir + f"/execution_time_{round_index + 1}.txt", "w") as f:
                            f.write(str(execution_time))
                        break
                    elif os.path.exists(save_code_dir + f"/code_{round_index + 1}_0.py"):
                        with_code = True
                        try:
                            result = subprocess.run(
                                ["python3", save_code_dir + f"/code_{round_index + 1}_0.py"],
                                capture_output=True, text=True, timeout=10
                            )
                            output = result.stdout
                            errors = result.stderr
                        except subprocess.TimeoutExpired as e:
                            output = e.stdout if e.stdout else ""
                            errors = e.stderr if e.stderr else ""
                            errors += f"\nTimeoutExpired: Command '{e.cmd}' timed out after {e.timeout} seconds"

                        multi_turn_question = multi_turn_planning_prompt_with_code + f'The execution result from the code is:\noutput: {output}, errors: {errors}'
                        user_prompt_list.append(multi_turn_question)
                        response_total_list.append(response_code)
                        end_time = time.time()
                        execution_time = end_time - start_time
                        execution_time_total += execution_time
                        with open(save_code_dir + f"/execution_time_{round_index + 1}.txt", "w") as f:
                            f.write(str(execution_time))
                    else:
                        # print(f'No code generated in round {round_index + 1}. Completed!')
                        multi_turn_question = multi_turn_planning_prompt_without_code
                        user_prompt_list.append(multi_turn_question)
                        response_total_list.append(response_code)

                        end_time = time.time()
                        execution_time = end_time - start_time
                        execution_time_total += execution_time
                        with open(save_code_dir + f"/execution_time_{round_index + 1}.txt", "w") as f:
                            f.write(str(execution_time))

                if with_code:
                    num_with_code += 1
                    time_with_code += execution_time_total
                else:
                    num_without_code += 1
                    time_without_code += execution_time_total
                print('target_answer:', target_answer)
                print('response_code:', response_code)

    print(f'ratio_with_code: {num_with_code/total_test_num}, ratio_without_code: {num_without_code/total_test_num}')
    if num_with_code != 0:
        print(f'average_time_with_code: {time_with_code/num_with_code}')
        with open(base_save_code_dir + f"/average_time_with_code.txt", "w") as f:
            f.write(str(time_with_code / num_with_code))
    if num_without_code != 0:
        print(f'average_time_without_code: {time_without_code/num_without_code}')
        with open(base_save_code_dir + f"/average_time_without_code.txt", "w") as f:
            f.write(str(time_without_code / num_without_code))

    print(f'Model_name: {model_name}, AutoGen_prompt_system_message: {AutoGen_prompt_system_message}, '
          f'AutoGen_prompt_concatenate: {AutoGen_prompt_concatenate}, code_interpreter: {code_interpreter}, Encourage_code_execution_interpreter: {Encourage_code_execution_interpreter}, '
          f'all_code_with_COT: {all_code_with_COT}, all_code_without_COT: {all_code_without_COT}, all_text: {all_text}, multi_turn_planning: {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}, '
          f'method_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n')
    print('*' * 30)

if __name__ == '__main__':
    # gpt-4o, gpt-4o-mini, gpt-3.5-turbo for OpenAi API
    # gpt-4o, gpt-35-turbo for Azure API
    # multi_turn_planning_round_num = [1, 2, 4, 8, 16]

    parser = ArgumentParser()
    parser.add_argument('-model_name', '--model_name', default='gpt-35-turbo-16k-0613')
    args = parser.parse_args()
    model_name = args.model_name

    dataset_input_dir = '../dataset_gather/number_multiply'
    save_input_dir = '../results_gather/number_multiply'

    if not os.path.exists(save_input_dir):
        os.makedirs(save_input_dir)

    def log_run_info(log_file, run_info):
        with open(log_file, 'a') as f:
            f.write(run_info + "\n")

    # for multi_turn_planning_round_num in [1, 2, 4, 8, 16]:
    for multi_turn_planning_round_num in [1]:
        # for model_name in ['gpt-4o', 'gpt-4o-mini', 'gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
        # for model_name in ['gpt-4o']:
        log_file = os.path.join(save_input_dir, f"run_log_{model_name}.txt")

        for dataset_input_dir, save_input_dir, model_name, code_interpreter, AutoGen_prompt_system_message, AutoGen_prompt_concatenate, \
            Encourage_code_execution_interpreter, all_code_with_COT, all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num \
                , method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first in [
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, True, False, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, True, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, True, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, True, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, True, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, True, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, False, True),
        ]:
            run_number_multiply(dataset_input_dir, save_input_dir, model_name,
                                         AutoGen_prompt_system_message,
                                         AutoGen_prompt_concatenate, code_interpreter,
                                         Encourage_code_execution_interpreter, all_code_with_COT,
                                         all_code_without_COT, all_text, multi_turn_planning,
                                         multi_turn_planning_round_num, method_9_all_text_all_code_summarizer,
                                         method_10_LLM_estimates_scores_first)

            # Log the completed run
            run_info = f"Completed run: {model_name}, round_num={multi_turn_planning_round_num}, " \
                       f"{code_interpreter}, {AutoGen_prompt_system_message}, {AutoGen_prompt_concatenate}, " \
                       f"{Encourage_code_execution_interpreter}, {all_code_with_COT}, {all_code_without_COT}, {all_text}, {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}" \
                       f"\nmethod_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n"
            log_run_info(log_file, run_info)


    #for model_name in ['gpt-4o', 'gpt-4o-mini', 'gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
    #for model_name in ['gpt-4o']:
    log_file = os.path.join(save_input_dir, f"run_log_{model_name}.txt")

    for dataset_input_dir, save_input_dir, model_name, code_interpreter, AutoGen_prompt_system_message, AutoGen_prompt_concatenate, \
        Encourage_code_execution_interpreter, all_code_with_COT, all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num\
        ,method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first in [
        (dataset_input_dir, save_input_dir, model_name, True, False, False, False, False, False, False, False, 1, False, False),
        (dataset_input_dir, save_input_dir, model_name, True, False, False, True, False, False, False, False, 1, False, False)
    ]:
        run_number_multiply(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
                      AutoGen_prompt_concatenate, code_interpreter, Encourage_code_execution_interpreter,
                      all_code_with_COT,
                      all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num, method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first)

        # Log the completed run
        run_info = f"Completed run: {model_name}, round_num={multi_turn_planning_round_num}, " \
                   f"{code_interpreter}, {AutoGen_prompt_system_message}, {AutoGen_prompt_concatenate}, " \
                   f"{Encourage_code_execution_interpreter}, {all_code_with_COT}, {all_code_without_COT}, {all_text}, {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}" \
                   f"\nmethod_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n"
        log_run_info(log_file, run_info)