from dotenv import load_dotenv
from openai import AzureOpenAI
from azure.identity import DefaultAzureCredential, get_bearer_token_provider
import json
import re
import pandas as pd
import os
import subprocess
import io
import sys
from openai import OpenAI
from typing_extensions import override
from openai import AssistantEventHandler
from generation_models import message_construct_func, GPT_response, count_total_tokens
import copy
import argparse
import tqdm
from typing import List, Tuple, Dict
import time
import numpy as np
import ast
from prompt import *
from argparse import ArgumentParser

def extract_code(text):
    # Regular expression to match code blocks enclosed in triple backticks
    code_block_pattern = re.compile(r'```python\n(.*?)\n```', re.DOTALL)

    # Find all matches in the text
    code_blocks = code_block_pattern.findall(text)

    # If no code blocks are found, try to find indented code blocks
    if not code_blocks:
        return []

    return code_blocks

# Define types
State = List[List[str]]
Action = Tuple[str, str, str]  # (block, from, to)

def state_to_prompt(state: State, goal: State) -> str:
    """
    Convert a Blocksworld state to a prompt description for the LLM.
    """
    prompt = "Blocksworld Task:\n\nInitial State:\n"
    for stack, blocks in state.items():
        prompt += f"{stack}: {' '.join(blocks)}\n"

    prompt += "\nGoal State:\n"
    for stack, blocks in goal.items():
        prompt += f"{stack}: {' '.join(blocks)}\n"

    prompt += "\nPlease provide a series of moves to reach the goal state. " \
              "You can only move one block at a time. And that box should be the top box of the stack. " \
              "Note that from the left to the right in each stack is the order from the bottom to the top of boxes. " \
              "For example, in stack A B C D, A is the bottom box and D is the top box so that you can only move D in this case. "
    prompt += "***Be careful that you can only pick up the top box in each stack. Check this rule before your move!***. "
    prompt += "\nEach move should be in the format: 'Move [block] from [source] to [destination]'. "
    prompt += "You cannot create new stacks but only move among the existing stacks. "
    prompt += "Separate each move with a newline. Surround the answer with <<<content>>>. "
    prompt += "Answer with the required format like the example: <<<Move B from 2 to table\nMove A from 1 to 2\nMove C from 3 to 1\nMove D from 3 to 2\nMove B from 1 to 2>>>\n"
    prompt += "Your answer: \n"

    return prompt


def validate_response(initial_state: State, goal_state: State, response: str) -> Tuple[bool, str]:
    """
    Validate the LLM's response and check if it reaches the goal state.
    """
    current_state = {stack: blocks.copy() for stack, blocks in initial_state.items()}
    #print('current_state:', current_state)
    moves = response.strip().split('\n')
    #print('goal state:', goal_state)
    for move in moves:
        parts = move.split()
        if len(parts) != 6 or parts[0] != "Move" or parts[2] != "from" or parts[4] != "to":
            return False, f"Invalid move format: {move}"

        block, source, destination = parts[1], parts[3], parts[5]
        if 'stack' not in source:
            source = 'stack' + source
        if 'stack' not in destination:
            destination = 'stack' + destination

        if source not in current_state or destination not in current_state:
            return False, f"Invalid source or destination stack: {move}"

        if not current_state[source] or current_state[source][-1] != block:
            return False, f"Invalid move: {move}. Block {block} is not at the top of the source stack."

        # Move the block
        moved_block = current_state[source].pop()
        current_state[destination].append(moved_block)
        #print('current_state:', current_state)

    def compare_states(state1, state2):
        state1_non_empty = {k: v for k, v in state1.items() if v}
        state2_non_empty = {k: v for k, v in state2.items() if v}
        return state1_non_empty == state2_non_empty

    # Check if the final state matches the goal state
    if compare_states(current_state, goal_state):
        return True, "Goal state reached successfully!"
    else:
        return False, "The final state does not match the goal state."

def read_state_from_file(filename: str) -> Tuple[State, State]:
    """
    Read the initial and goal states from a text file.
    """
    initial_state = {}
    goal_state = {}
    current_state = initial_state

    with open(filename, 'r') as f:
        lines = f.readlines()

    for line in lines:
        line = line.strip()
        if line == "Initial State:":
            current_state = initial_state
        elif line == "Goal State:":
            current_state = goal_state
        elif line:
            parts = line.split(': ')
            stack = parts[0] if len(parts) > 1 else parts[0][:-1]
            blocks = parts[1].split() if len(parts) > 1 else []
            current_state[stack] = blocks

    return initial_state, goal_state

def extract_equation_with_GPT4(response):
    prompt = 'Your task is to extract the final answer of the given answer by another LLM:\n' \
             'Here is the response, return your answer with the format <<<list>>>, like <<<Yes>>>, <<<No>>>.\n' \
             'If the input text does not have <<<>>> and is already the pure answer, add <<<>>> and return your answer.\n' \
             'Note that if you find no final answer is answered, then directly answer <<<No answer found>>>.\n' \
             'Input text: ' \

    extract_equation = GPT_response('', prompt + response, model_name='gpt-4o', code_interpreter=False, user_prompt_list = [prompt + response], response_total_list = [])
    return extract_equation

def extract_and_check(response):
    # Extract all texts between <<< and >>>
    matches = re.findall(r'<<<(.*?)>>>', response, re.DOTALL)
    extracted_text = matches[-1].strip() if matches else ''

    # Check if 'itertools' appears in the response
    itertools_present = '```python' in response

    return extracted_text, itertools_present

def run_blocksworld(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
               AutoGen_prompt_concatenate, code_interpreter, Encourage_code_execution_interpreter, all_code_with_COT,
               all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num, method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first):
    print('\n' + '*'*30)
    print(f'Model_name: {model_name}, AutoGen_prompt_system_message: {AutoGen_prompt_system_message}, '
          f'AutoGen_prompt_concatenate: {AutoGen_prompt_concatenate}, code_interpreter: {code_interpreter}, Encourage_code_execution_interpreter: {Encourage_code_execution_interpreter}, '
          f'all_code_with_COT: {all_code_with_COT}, all_code_without_COT: {all_code_without_COT}, all_text: {all_text}, multi_turn_planning: {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}, '
          f'method_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n')

    total_test_num = 0
    num_with_code = 0
    num_without_code = 0
    time_with_code = 0
    time_without_code = 0

    if method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == False:
        base_save_code_dir = save_input_dir + f'/result_blocksworld_{model_name}_interpreter_{code_interpreter}_AutoGen_system_{AutoGen_prompt_system_message}_AutoGen_concatenate_{AutoGen_prompt_concatenate}_all_code_with_COT_{all_code_with_COT}_all_code_without_COT_{all_code_without_COT}_Encourage_code_execution_interpreter_{Encourage_code_execution_interpreter}_all_text_{all_text}_multi_turn_planning_{multi_turn_planning}_round_num_{multi_turn_planning_round_num}'
    elif method_9_all_text_all_code_summarizer == True and method_10_LLM_estimates_scores_first == False:
        base_save_code_dir = save_input_dir + f'/result_blocksworld_{model_name}_method_9_all_text_all_code_summarizer'
    elif method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == True:
        base_save_code_dir = save_input_dir + f'/result_blocksworld_{model_name}_method_10_LLM_estimates_scores_first'
    else:
        raise ValueError(
            "method_9_all_text_all_code_summarizer and method_10_LLM_estimates_scores_first can't be both True")

    if not os.path.exists(base_save_code_dir):
        os.makedirs(base_save_code_dir)

    for num_blocks, initial_stacks, goal_stacks in [
        (2, 3, 2), (2, 3, 3), (2, 4, 2), (2, 4, 3), (2, 4, 4), (2, 5, 2), (2, 5, 3), (2, 5, 4),
        (3, 3, 2), (3, 3, 3), (3, 4, 2), (3, 4, 3), (3, 4, 4), (3, 5, 2), (3, 5, 3), (3, 5, 4),
        (4, 3, 2), (4, 3, 3), (4, 4, 2), (4, 4, 3), (4, 4, 4), (4, 5, 2), (4, 5, 3), (4, 5, 4)
    ]:
        for index in range(5):
            with_code = False
            total_test_num += 1
            dataset_base_dir_sample = os.path.join(dataset_input_dir, f"{num_blocks}_{initial_stacks}_{goal_stacks}_{index}/")
            # Read states from file
            initial_state, goal_state = read_state_from_file(dataset_base_dir_sample + f"blocksworld_task.txt")
            print(f'num_blocks: {num_blocks}, initial_stacks: {initial_stacks}, goal_stacks: {goal_stacks}, index: {index}')

            save_code_dir = os.path.join(base_save_code_dir, f"{num_blocks}_{initial_stacks}_{goal_stacks}_{index}/")
            if not os.path.exists(save_code_dir):
                os.makedirs(save_code_dir)

            # Generate prompt from the read states
            question = state_to_prompt(initial_state, goal_state)

            response_total_list = [];
            system_message = ""

            if method_9_all_text_all_code_summarizer == True and method_10_LLM_estimates_scores_first == False:
                base_save_code_dir_all_text = save_input_dir + f'/result_blocksworld_{model_name}_interpreter_False_AutoGen_system_False_AutoGen_concatenate_False_all_code_with_COT_False_all_code_without_COT_False_Encourage_code_execution_interpreter_False_all_text_True_multi_turn_planning_True_round_num_{multi_turn_planning_round_num}'
                base_save_code_dir_all_code = save_input_dir + f'/result_blocksworld_{model_name}_interpreter_False_AutoGen_system_False_AutoGen_concatenate_False_all_code_with_COT_False_all_code_without_COT_True_Encourage_code_execution_interpreter_False_all_text_False_multi_turn_planning_True_round_num_{multi_turn_planning_round_num}'
                save_code_dir_all_text = os.path.join(base_save_code_dir_all_text, f"{num_blocks}_{initial_stacks}_{goal_stacks}_{index}/")
                save_code_dir_all_code = os.path.join(base_save_code_dir_all_code, f"{num_blocks}_{initial_stacks}_{goal_stacks}_{index}/")
                with open(save_code_dir_all_text + f"/response_code_1.txt", "r") as f:
                    response_all_text = f.read()
                with open(save_code_dir_all_code + f"/response_code_1.txt", "r") as f:
                    response_all_code = f.read()
                input_prompt = combined_agent_prompt + '###The input question is: \n' + question + f'\n\n'
                input_prompt = input_prompt + f'\nThe response from Agent_1 is: {response_all_text}'

                if os.path.exists(save_code_dir_all_text + f"/code_1_0.py"):
                    with open(save_code_dir_all_text + f"/response_answer.txt", "r") as f:
                        extracted_all_text = f.read()
                    input_prompt = input_prompt + f'\nThe execution result from the Agent_1 code is: {extracted_all_text}'

                input_prompt = input_prompt + f'\n\nThe response from Agent_2 is: {response_all_code}'
                if os.path.exists(save_code_dir_all_code + f"/code_1_0.py"):
                    with open(save_code_dir_all_code + f"/response_answer.txt", "r") as f:
                        extracted_all_code = f.read()
                    input_prompt = input_prompt + f'\nThe execution result from the Agent_2 code is: {extracted_all_code}'
                input_prompt = input_prompt + f'\n\nNow you need to analyze the problem based on their answers and output final answer with the required format in the original question. Your analysis and answer:\n'

                # print(f'\n#########input_prompt: \n{input_prompt}')
                user_prompt_list = [input_prompt]

            elif method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == True:
                user_prompt_list = [method_10_self_estimate_score_prompt + question]


            elif Encourage_code_execution_interpreter == True and code_interpreter == True and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                user_prompt_list = [Encourage_code_execution_prompt_for_code_interpreter + question]
            elif AutoGen_prompt_system_message == True and AutoGen_prompt_concatenate == False and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                system_message = AutoGen_prompt
                user_prompt_list = [question]
            elif AutoGen_prompt_system_message == False and AutoGen_prompt_concatenate == True and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                user_prompt_list = [AutoGen_prompt + question]
            elif AutoGen_prompt_system_message == False and AutoGen_prompt_concatenate == False and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                user_prompt_list = [question]
            elif code_interpreter == False and all_code_with_COT == True and all_code_without_COT == False and all_text == False:
                user_prompt_list = [with_COT_all_code_prompt_2 + question]
            elif code_interpreter == False and all_code_with_COT == False and all_code_without_COT == True and all_text == False:
                user_prompt_list = [without_COT_all_code_prompt_1 + question]
            elif code_interpreter == False and all_code_with_COT == False and all_code_without_COT == False and all_text == True:
                user_prompt_list = [text_output_prompt + question]
            with open(save_code_dir + f"/system_message.txt", "w") as f:
                f.write(system_message)

            if multi_turn_planning:
                round_number = multi_turn_planning_round_num
            else:
                round_number = 1

            execution_time_total = 0
            for round_index in range(round_number):
                with open(save_code_dir + f"/input_prompt_{round_index + 1}.txt", "w") as f:
                    f.write(user_prompt_list[round_index])

                print(f'Round {round_index + 1}')
                start_time = time.time()

                # 15000 tokens limit for gpt-3.5-turbo
                if count_total_tokens(user_prompt_list, response_total_list) > 15000 and model_name in ['gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
                    break

                response_code = GPT_response("", user_prompt_list[0], model_name=model_name,
                                             code_interpreter=code_interpreter, user_prompt_list=user_prompt_list,
                                             response_total_list=response_total_list)
                code_block_list = extract_code(response_code)
                for index_code, code_string in enumerate(code_block_list):
                    with open(save_code_dir + f"/code_{round_index + 1}_{index_code}.txt", "w") as f:
                        f.write(code_string)
                with open(save_code_dir + f"/response_code_{round_index + 1}.txt", "w") as f:
                    f.write(response_code)
                if 'TERMINATE' in response_code:
                    print(f'Terminate in round {round_index + 1}. Completed!')
                    end_time = time.time()
                    execution_time = end_time - start_time
                    execution_time_total += execution_time
                    with open(save_code_dir + f"/execution_time_{round_index + 1}.txt", "w") as f:
                        f.write(str(execution_time))
                    break
                elif os.path.exists(save_code_dir + f"/code_{round_index + 1}_0.py"):
                    with_code = True
                    try:
                        result = subprocess.run(
                            ["python3", save_code_dir + f"/code_{round_index + 1}_0.py"],
                            capture_output=True, text=True, timeout=10
                        )
                        output = result.stdout
                        errors = result.stderr
                    except subprocess.TimeoutExpired as e:
                        output = e.stdout if e.stdout else ""
                        errors = e.stderr if e.stderr else ""
                        errors += f"\nTimeoutExpired: Command '{e.cmd}' timed out after {e.timeout} seconds"

                    multi_turn_question = multi_turn_planning_prompt_with_code + f'The execution result from the code is:\noutput: {output}, errors: {errors}'
                    user_prompt_list.append(multi_turn_question)
                    response_total_list.append(response_code)
                    end_time = time.time()
                    execution_time = end_time - start_time
                    execution_time_total += execution_time
                    with open(save_code_dir + f"/execution_time_{round_index + 1}.txt", "w") as f:
                        f.write(str(execution_time))
                else:
                    # print(f'No code generated in round {round_index + 1}. Completed!')
                    multi_turn_question = multi_turn_planning_prompt_without_code
                    user_prompt_list.append(multi_turn_question)
                    response_total_list.append(response_code)

                    end_time = time.time()
                    execution_time = end_time - start_time
                    execution_time_total += execution_time
                    with open(save_code_dir + f"/execution_time_{round_index + 1}.txt", "w") as f:
                        f.write(str(execution_time))

            if with_code:
                num_with_code += 1
                time_with_code += execution_time_total
            else:
                num_without_code += 1
                time_without_code += execution_time_total

    print(
        f'ratio_with_code: {num_with_code / total_test_num}, ratio_without_code: {num_without_code / total_test_num}')
    if num_with_code != 0:
        print(f'average_time_with_code: {time_with_code / num_with_code}')
        with open(base_save_code_dir + f"/average_time_with_code.txt", "w") as f:
            f.write(str(time_with_code / num_with_code))
    if num_without_code != 0:
        print(f'average_time_without_code: {time_without_code / num_without_code}')
        with open(base_save_code_dir + f"/average_time_without_code.txt", "w") as f:
            f.write(str(time_without_code / num_without_code))

    print(f'Model_name: {model_name}, AutoGen_prompt_system_message: {AutoGen_prompt_system_message}, '
          f'AutoGen_prompt_concatenate: {AutoGen_prompt_concatenate}, code_interpreter: {code_interpreter}, Encourage_code_execution_interpreter: {Encourage_code_execution_interpreter}, '
          f'all_code_with_COT: {all_code_with_COT}, all_code_without_COT: {all_code_without_COT}, all_text: {all_text}, multi_turn_planning: {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}, '
          f'method_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n')
    print('*' * 30)

if __name__ == '__main__':
    # gpt-4o, gpt-4o-mini, gpt-3.5-turbo for OpenAi API
    # gpt-4o, gpt-35-turbo for Azure API
    # multi_turn_planning_round_num = [1, 2, 4, 8, 16]

    parser = ArgumentParser()
    parser.add_argument('-model_name', '--model_name', default='gpt-35-turbo-16k-0613')
    args = parser.parse_args()
    model_name = args.model_name

    dataset_input_dir = '../dataset_gather/Blocksworld_dataset'
    save_input_dir = '../results_gather/blocksworld'

    if not os.path.exists(save_input_dir):
        os.makedirs(save_input_dir)

    def log_run_info(log_file, run_info):
        with open(log_file, 'a') as f:
            f.write(run_info + "\n")

    # for multi_turn_planning_round_num in [1, 2, 4, 8, 16]:
    for multi_turn_planning_round_num in [1]:
        # for model_name in ['gpt-4o', 'gpt-4o-mini', 'gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
        # for model_name in ['gpt-4o']:
        log_file = os.path.join(save_input_dir, f"run_log_{model_name}.txt")

        for dataset_input_dir, save_input_dir, model_name, code_interpreter, AutoGen_prompt_system_message, AutoGen_prompt_concatenate, \
            Encourage_code_execution_interpreter, all_code_with_COT, all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num \
                , method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first in [
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, True, False, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, True, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, True, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, True, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, True, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, True, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, False, True),
        ]:
            run_blocksworld(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
                                     AutoGen_prompt_concatenate, code_interpreter,
                                     Encourage_code_execution_interpreter,
                                     all_code_with_COT,
                                     all_code_without_COT, all_text, multi_turn_planning,
                                     multi_turn_planning_round_num,
                                     method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first)

            # Log the completed run
            run_info = f"Completed run: {model_name}, round_num={multi_turn_planning_round_num}, " \
                       f"{code_interpreter}, {AutoGen_prompt_system_message}, {AutoGen_prompt_concatenate}, " \
                       f"{Encourage_code_execution_interpreter}, {all_code_with_COT}, {all_code_without_COT}, {all_text}, {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}" \
                       f"\nmethod_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n"
            log_run_info(log_file, run_info)


    #for model_name in ['gpt-4o', 'gpt-4o-mini', 'gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
    #for model_name in ['gpt-4o']:
    log_file = os.path.join(save_input_dir, f"run_log_{model_name}.txt")

    for dataset_input_dir, save_input_dir, model_name, code_interpreter, AutoGen_prompt_system_message, AutoGen_prompt_concatenate, \
        Encourage_code_execution_interpreter, all_code_with_COT, all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num\
        ,method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first in [
        (dataset_input_dir, save_input_dir, model_name, True, False, False, False, False, False, False, False, 1, False, False),
        (dataset_input_dir, save_input_dir, model_name, True, False, False, True, False, False, False, False, 1, False, False)
    ]:
        run_blocksworld(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
                      AutoGen_prompt_concatenate, code_interpreter, Encourage_code_execution_interpreter,
                      all_code_with_COT,
                      all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num, method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first)

        # Log the completed run
        run_info = f"Completed run: {model_name}, round_num={multi_turn_planning_round_num}, " \
                   f"{code_interpreter}, {AutoGen_prompt_system_message}, {AutoGen_prompt_concatenate}, " \
                   f"{Encourage_code_execution_interpreter}, {all_code_with_COT}, {all_code_without_COT}, {all_text}, {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}" \
                   f"\nmethod_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n"
        log_run_info(log_file, run_info)