from dotenv import load_dotenv
from openai import AzureOpenAI
from azure.identity import DefaultAzureCredential, get_bearer_token_provider
import json
import re
import os
import subprocess
import io
import sys
from openai import OpenAI
from typing_extensions import override
from openai import AssistantEventHandler
from generation_models import message_construct_func, GPT_response, count_total_tokens
import copy
import argparse
from datasets import load_dataset
import time
import numpy as np
from prompt import *
from argparse import ArgumentParser

def extract_code(text):
    # Regular expression to match code blocks enclosed in triple backticks
    code_block_pattern = re.compile(r'```python\n(.*?)\n```', re.DOTALL)

    # Find all matches in the text
    code_blocks = code_block_pattern.findall(text)

    # If no code blocks are found, try to find indented code blocks
    if not code_blocks:
        return []

    return code_blocks

def extract_and_check(response):
    # Extract all texts between <<< and >>>
    matches = re.findall(r'<<<(.*?)>>>', response)
    extracted_text = matches[-1].strip() if matches else ''

    # Check if 'itertools' appears in the response
    itertools_present = '```python' in response

    return extracted_text, itertools_present


def run_path_plan(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
               AutoGen_prompt_concatenate, code_interpreter, Encourage_code_execution_interpreter, all_code_with_COT,
               all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num, method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first):
    print('\n' + '*'*30)
    print(f'Model_name: {model_name}, AutoGen_prompt_system_message: {AutoGen_prompt_system_message}, '
          f'AutoGen_prompt_concatenate: {AutoGen_prompt_concatenate}, code_interpreter: {code_interpreter}, Encourage_code_execution_interpreter: {Encourage_code_execution_interpreter}, '
          f'all_code_with_COT: {all_code_with_COT}, all_code_without_COT: {all_code_without_COT}, all_text: {all_text}, multi_turn_planning: {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}, '
          f'method_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n')

    if method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == False:
        base_save_code_dir = save_input_dir + f'/result_path_plan_{model_name}_interpreter_{code_interpreter}_AutoGen_system_{AutoGen_prompt_system_message}_AutoGen_concatenate_{AutoGen_prompt_concatenate}_all_code_with_COT_{all_code_with_COT}_all_code_without_COT_{all_code_without_COT}_Encourage_code_execution_interpreter_{Encourage_code_execution_interpreter}_all_text_{all_text}_multi_turn_planning_{multi_turn_planning}_round_num_{multi_turn_planning_round_num}'
    elif method_9_all_text_all_code_summarizer == True and method_10_LLM_estimates_scores_first == False:
        base_save_code_dir = save_input_dir + f'/result_path_plan_{model_name}_method_9_all_text_all_code_summarizer'
    elif method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == True:
        base_save_code_dir = save_input_dir + f'/result_path_plan_{model_name}_method_10_LLM_estimates_scores_first'
    else:
        raise ValueError("method_9_all_text_all_code_summarizer and method_10_LLM_estimates_scores_first can't be both True")

    total_test_num = 0
    num_with_code = 0
    num_without_code = 0
    time_with_code = 0
    time_without_code = 0

    if not os.path.exists(base_save_code_dir):
        os.makedirs(base_save_code_dir)

    walls = [(-1.5, -1.4, -1.5, 1.5), (1.4, 1.5, -1.5, 1.5), (-1.5, 1.5, -1.5, -1.4), (-1.5, 1.5, 1.4, 1.5)]

    # First Environment
    box_dict_1 = {'yellow': (-1, -0.7, -0.25, 0.5), 'red': (0, 0.9, -1, -0.5), 'green': (0.2, 0.7, 0.8, 1.2),
                'blue': (-0.5, 0.5, -0.5, 0.5), 'pink': (-1.2, 0.0, 0.6, 0.9), 'purple': (-1.0, -0.5, -1.3, -0.9), 'orange': (0.6, 1.2, -0.5, 0.5)}
    starting_position_1 = (-1.3, -1.3); ending_position_1 = (1.3, 1.3)
    Instruction_simple_houseworld_1_list = \
        ['Navigate into the green room and then go to the yellow room. Should be in order.',
        'Navigate into the yellow room, then go to the purple room, and then to the red room, and then to the green room. The places should be visited in order.',
        'Navigate into the yellow room, then go to the purple room, and then to the red room, and then to the green room. The places should be visited in order. Remember do not enter the blue area all the time.',
        'Navigate into the green room and then go to the yellow room, the places should be visited in order.',
        'Visit blue region during your trajectory, but never enter all the other colored boxes.',
        'Navigate into the green room and then go to the yellow room, the places should be visited in order. Remember do not enter the pink area all the time.',
        'Navigate into the yellow room and then go to the orange room, the places should be visited in order. Remember do not enter the blue, purple, and red areas all the time.',
        'Navigate into the green room and then go to the yellow room and then go to the red room, the places should be visited in order. Remember do not enter the blue area all the time.',
        'Visit purple, orange, and pink areas in order, but remember never enter all the other colored areas.',
        'At some point go to the yellow box, and then at some point go to the red box, and then enter the green box, and always do not enter the blue area. The places should be visited in order.']

    # Second Environment
    box_dict_2 = box_dict_1; starting_position_2 = (1.3, -1.3); ending_position_2 = (1.3, 1.3); Instruction_simple_houseworld_2_list = Instruction_simple_houseworld_1_list

    # Third Environment
    box_dict_3 = {'yellow': (-1, -0.7, -0.25, 0.5), 'red': (0, 0.9, -1, -0.5), 'green': (0.2, 0.7, 0.8, 1.2),
                'blue': (-0.2, 0.2, -0.2, 0.2), 'pink': (-1.2, 0.0, 0.6, 0.9), 'purple': (-1.0, -0.5, -1.3, -0.9), 'orange': (0.6, 1.2, -0.5, 0.5)}
    starting_position_3 = starting_position_1; ending_position_3 = ending_position_1; Instruction_simple_houseworld_3_list = Instruction_simple_houseworld_1_list

    # Forth Environment
    box_dict_4 = box_dict_1; starting_position_4 = (-1.3, 1.3); ending_position_4 = (1.3, 1.3); Instruction_simple_houseworld_4_list = Instruction_simple_houseworld_1_list

    # Fifth Environment
    box_dict_5 = {'red': (-1, -0.7, -0.25, 0.5), 'yellow': (0, 0.9, -1.3, -0.8), 'green': (0.2, 0.7, 0.8, 1.2),
                'blue': (-0.3, 0.3, -0.3, 0.3), 'orange': (-1.2, 0.0, 0.6, 0.9), 'purple': (-1.0, -0.5, -1.3, -0.7), 'pink': (0.6, 1.2, -0.5, 0.5)}
    starting_position_5 = (1.3, -1.3); ending_position_5 = (1.3, 1.3); Instruction_simple_houseworld_5_list = Instruction_simple_houseworld_1_list

    # Sixth Environment
    box_dict_6 = {'red': (-1, -0.7, -0.25, 0.5), 'yellow': (0, 0.9, -1.3, -0.6), 'green': (0.1, 0.9, 0.7, 1.4),
                'blue': (-0.3, 0.3, -0.3, 0.3), 'orange': (-1.2, 0.0, 0.6, 0.9), 'purple': (-1.0, -0.25, -1.3, -0.5),
                'pink': (0.6, 1.2, -0.5, 0.5)}
    starting_position_6 = (1.3, -1.3); ending_position_6 = (1.3, 1.3); Instruction_simple_houseworld_6_list = Instruction_simple_houseworld_1_list

    # Seventh Environment
    box_dict_7 = {'pink': (-1, -0.7, -0.25, 0.5), 'purple': (0, 0.9, -1.3, -0.6), 'green': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.3, 0.3, -0.3, 0.3), 'orange': (-1.2, 0.0, 0.6, 1.4), 'yellow': (-1.0, -0.25, -1.3, -0.5),
                'red': (0.6, 1.2, -0.5, 0.5)}
    starting_position_7 = (1.1, 1.3); ending_position_7 = (-1.3, 1.1); Instruction_simple_houseworld_7_list = Instruction_simple_houseworld_1_list

    # Eighth Environment
    box_dict_8 = {'pink': (-1.3, -0.9, -0.25, 0.5), 'purple': (0, 0.9, -1.3, -0.7), 'green': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.55, 0.55, -0.55, 0.55), 'orange': (-1.2, 0.0, 0.7, 1.3),
                'yellow': (-1.0, -0.25, -1.3, -0.7), 'red': (0.7, 1.2, -0.5, 0.5)}
    starting_position_8 = (1.3, 1.3); ending_position_8 = (-1.3, -1.3); Instruction_simple_houseworld_8_list = Instruction_simple_houseworld_1_list

    # Ninth Environment
    box_dict_9 = {'pink': (-1.3, -0.9, -0.25, 0.5), 'purple': (-0.3, 0.6, -1.3, -0.7), 'green': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.55, 1.4, -0.3, 0.5), 'orange': (-1.2, 0.0, 0.7, 1.3), 'yellow': (-1.3, -0.4, -1.3, -0.7),
                'red': (0.7, 1.2, -1.2, -0.5)}
    starting_position_9 = (1.35, 1.35); ending_position_9 = (-1.35, -1.35); Instruction_simple_houseworld_9_list = Instruction_simple_houseworld_1_list

    # Tenth Environment
    box_dict_10 = {'pink': (-1.3, -0.9, -0.25, 0.5), 'purple': (-0.3, 0.6, -1.3, -0.7), 'green': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.55, 1.4, -0.3, 0.5), 'orange': (-1.2, 0.0, 0.7, 1.3), 'yellow': (-1.3, -0.4, -1.3, -0.7),
                'red': (0.7, 1.2, -1.2, -0.5)}
    starting_position_10 = (-1.35, 1.35); ending_position_10 = (1.35, -1.35); Instruction_simple_houseworld_10_list = Instruction_simple_houseworld_1_list

    # Eleventh Environment
    box_dict_11 = {'green': (-1.3, -0.8, -0.25, 0.5), 'purple': (-0.3, 0.6, -1.1, -0.5), 'pink': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.55, 1.4, -0.3, 0.5), 'orange': (-1.2, 0.0, 0.7, 1.3), 'yellow': (-1.3, -0.4, -1.1, -0.5),
                'red': (0.7, 1.2, -1.2, -0.7)}
    starting_position_11 = (1.35, -1.35); ending_position_11 = (-1.35, 1.35); Instruction_simple_houseworld_11_list = Instruction_simple_houseworld_1_list

    # Twelfth Environment
    box_dict_12 = {'green': (-1.3, -0.8, -0.25, 0.5), 'purple': (-0.3, 0.6, -1.1, -0.5), 'pink': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.55, 1.4, -0.3, 0.5), 'orange': (-1.2, 0.0, 0.7, 1.3), 'yellow': (-1.3, -0.4, -1.1, -0.5),
                'red': (0.7, 1.2, -1.2, -0.7)}
    starting_position_12 = (1.2, 0.9); ending_position_12 = (-1.35, -1.35); Instruction_simple_houseworld_12_list = Instruction_simple_houseworld_1_list

    # Thirteenth Environment
    box_dict_13 = {'green': (-1.3, -0.8, -0.25, 0.5), 'purple': (-0.3, 0.6, -1.1, -0.5), 'pink': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.55, 1.4, -0.3, 0.5), 'orange': (-1.2, 0.0, 0.7, 1.3), 'yellow': (-1.3, -0.4, -1.1, -0.5),
                'red': (0.7, 1.2, -1.2, -0.7)}
    starting_position_13 = (-0.7, 0.0); ending_position_13 = (1.3, -0.5); Instruction_simple_houseworld_13_list = Instruction_simple_houseworld_1_list

    # Fourteenth Environment
    box_dict_14 = {'pink': (-1.3, -0.9, -0.25, 0.5), 'purple': (0, 0.9, -1.3, -0.7), 'green': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.55, 0.55, -0.55, 0.55), 'orange': (-1.2, 0.0, 0.7, 1.3),
                'yellow': (-1.0, -0.25, -1.3, -0.7), 'red': (0.7, 1.2, -0.5, 0.5)}
    starting_position_14 = (-0.7, 0.0); ending_position_14 = (-1.3, -1.3); Instruction_simple_houseworld_14_list = Instruction_simple_houseworld_1_list

    box_dict_list = [box_dict_1, box_dict_2, box_dict_3, box_dict_4, box_dict_5, box_dict_6, box_dict_7, box_dict_8, box_dict_9, box_dict_10, box_dict_11, box_dict_12, box_dict_13, box_dict_14]
    starting_position_list = [starting_position_1, starting_position_2, starting_position_3, starting_position_4, starting_position_5, starting_position_6, starting_position_7, starting_position_8, starting_position_9, starting_position_10, starting_position_11, starting_position_12, starting_position_13, starting_position_14]
    ending_position_list = [ending_position_1, ending_position_2, ending_position_3, ending_position_4, ending_position_5, ending_position_6, ending_position_7, ending_position_8, ending_position_9, ending_position_10, ending_position_11, ending_position_12, ending_position_13, ending_position_14]
    Instruction_simple_houseworld_list_gather = [Instruction_simple_houseworld_1_list, Instruction_simple_houseworld_2_list, Instruction_simple_houseworld_3_list,
                                                 Instruction_simple_houseworld_4_list, Instruction_simple_houseworld_5_list, Instruction_simple_houseworld_6_list,
                                                 Instruction_simple_houseworld_7_list, Instruction_simple_houseworld_8_list, Instruction_simple_houseworld_9_list,
                                                 Instruction_simple_houseworld_10_list, Instruction_simple_houseworld_11_list, Instruction_simple_houseworld_12_list,
                                                 Instruction_simple_houseworld_13_list, Instruction_simple_houseworld_14_list]

    for env_index in range(14):
        box_dict = box_dict_list[env_index]; starting_position = starting_position_list[env_index]; ending_position = ending_position_list[env_index]
        Instruction_simple_houseworld_list = Instruction_simple_houseworld_list_gather[env_index]

        num_wall = len(walls)
        Environment_description_houseworld = f'First, there are four black colored walls with position {walls[0]}'
        for i in range(1, num_wall):
          Environment_description_houseworld += f', {walls[i]}'
        Environment_description_houseworld += '. Then the boxes are:'
        for color, box in box_dict.items():
          Environment_description_houseworld += f' a {color} colored box {box};'
        Environment_description_houseworld = Environment_description_houseworld[:-1]
        Environment_description_houseworld += '.'

        for index in range(len(Instruction_simple_houseworld_list)):
            with_code = False
            total_test_num += 1
            Instruction_simple_houseworld = Instruction_simple_houseworld_list[index]
            question=f'''
            I am a mobile robot and I hope you can help me plan the trajectory to fulfill the navigation instruction. I will give you the position and size of each box in the whole environment and the instruction is to enter or avoid the box. Each box is of square shape, I will give you (x_start, x_end, y_start, y_end) to describe the shape of squares/boxes. x_start, x_end denote the boundary of squares/boxes in x coordinates. y_start, y_end denote the boundary of squares/boxes in y coordinates. 
            \n{Environment_description_houseworld}
            \nDuring navigation, the trajectory should always not touch the black wall. The starting position of the car is {starting_position}, the ending position of the car is {ending_position}.
            \nThe instruction is '{Instruction_simple_houseworld}'. The car should fulfill the instruction and in the end stop at the end position. Could you give me the trajectory to realize the above instruction? Return your answer with a list of waypoints [(x0, y0), (x1, y1)...].
            \nNote that the whole trajectory is acquired by directly connecting the near waypoints with straight lines. These straight lines should also fulfill the instruction requirements. Particularly check whether the interpolated straight lines enter into the areas that should avoid.
            \nNote that entering in the area means the trajectory intersects with the box, including the boundary of the box. Hence, the trajectory should not intersect with the boundary of the box if the instruction is to avoid the box.
            '''

            save_code_dir = os.path.join(base_save_code_dir, f'sample_{env_index}_{index}')
            if not os.path.exists(save_code_dir):
                os.makedirs(save_code_dir)

            print(f'\nsample_{env_index}_{index}')
            response_total_list = []; system_message = ""

            if method_9_all_text_all_code_summarizer == True and method_10_LLM_estimates_scores_first == False:
                base_save_code_dir_all_text = save_input_dir + f'/result_path_plan_{model_name}_interpreter_False_AutoGen_system_False_AutoGen_concatenate_False_all_code_with_COT_False_all_code_without_COT_False_Encourage_code_execution_interpreter_False_all_text_True_multi_turn_planning_True_round_num_{multi_turn_planning_round_num}'
                base_save_code_dir_all_code = save_input_dir + f'/result_path_plan_{model_name}_interpreter_False_AutoGen_system_False_AutoGen_concatenate_False_all_code_with_COT_False_all_code_without_COT_True_Encourage_code_execution_interpreter_False_all_text_False_multi_turn_planning_True_round_num_{multi_turn_planning_round_num}'
                save_code_dir_all_text = os.path.join(base_save_code_dir_all_text, f"sample_{env_index}_{index}/")
                save_code_dir_all_code = os.path.join(base_save_code_dir_all_code, f"sample_{env_index}_{index}/")
                with open(save_code_dir_all_text + f"/response_code_1.txt", "r") as f:
                    response_all_text = f.read()
                with open(save_code_dir_all_code + f"/response_code_1.txt", "r") as f:
                    response_all_code = f.read()
                input_prompt = combined_agent_prompt + '###The input question is: \n' + question + f'\n\n'
                input_prompt = input_prompt + f'\nThe response from Agent_1 is: {response_all_text}'

                if os.path.exists(save_code_dir_all_text + f"/code_1_0.py"):
                    with open(save_code_dir_all_text + f"/extracted_answer_1.txt", "r") as f:
                        extracted_all_text = f.read()
                    input_prompt = input_prompt + f'\nThe execution result from the Agent_1 code is: {extracted_all_text}'

                input_prompt = input_prompt + f'\n\nThe response from Agent_2 is: {response_all_code}'
                if os.path.exists(save_code_dir_all_code + f"/code_1_0.py"):
                    with open(save_code_dir_all_code + f"/extracted_answer_1.txt", "r") as f:
                        extracted_all_code = f.read()
                    input_prompt = input_prompt + f'\nThe execution result from the Agent_2 code is: {extracted_all_code}'
                input_prompt = input_prompt + f'\n\nNow you need to analyze the problem based on their answers and output final answer with the required format in the original question. Your analysis and answer:\n'

                # print(f'\n#########input_prompt: \n{input_prompt}')
                user_prompt_list = [input_prompt]

            elif method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == True:
                user_prompt_list = [method_10_self_estimate_score_prompt + question]
            elif Encourage_code_execution_interpreter == True and code_interpreter == True and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                user_prompt_list = [Encourage_code_execution_prompt_for_code_interpreter + question]
            elif AutoGen_prompt_system_message == True and AutoGen_prompt_concatenate == False and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                system_message = AutoGen_prompt
                user_prompt_list = [question]
            elif AutoGen_prompt_system_message == False and AutoGen_prompt_concatenate == True and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                user_prompt_list = [AutoGen_prompt + question]
            elif AutoGen_prompt_system_message == False and AutoGen_prompt_concatenate == False and all_code_with_COT == False and all_code_without_COT == False and all_text == False:
                user_prompt_list = [question]
            elif code_interpreter == False and all_code_with_COT == True and all_code_without_COT == False and all_text == False:
                user_prompt_list = [with_COT_all_code_prompt_2 + question]
            elif code_interpreter == False and all_code_with_COT == False and all_code_without_COT == True and all_text == False:
                user_prompt_list = [without_COT_all_code_prompt_1 + question]
            elif code_interpreter == False and all_code_with_COT == False and all_code_without_COT == False and all_text == True:
                user_prompt_list = [text_output_prompt + question]
            with open(save_code_dir + f"/system_message.txt", "w") as f:
                f.write(system_message)

            if multi_turn_planning:
                round_number = multi_turn_planning_round_num
            else:
                round_number = 1

            execution_time_total = 0
            for round_index in range(round_number):
                with open(save_code_dir + f"/input_prompt_{round_index + 1}.txt", "w") as f:
                    f.write(user_prompt_list[round_index])

                print(f'Round {round_index + 1}')
                start_time = time.time()

                # 15000 tokens limit for gpt-3.5-turbo
                if count_total_tokens(user_prompt_list, response_total_list) > 15000 and  model_name in ['gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
                    break

                response_code = GPT_response("", user_prompt_list[0], model_name=model_name,
                                             code_interpreter=code_interpreter, user_prompt_list=user_prompt_list,
                                             response_total_list=response_total_list)
                code_block_list = extract_code(response_code)
                for index_code, code_string in enumerate(code_block_list):
                    with open(save_code_dir + f"/code_{round_index + 1}_{index_code}.txt", "w") as f:
                        f.write(code_string)
                with open(save_code_dir + f"/response_code_{round_index + 1}.txt", "w") as f:
                    f.write(response_code)
                if 'TERMINATE' in response_code:
                    print(f'Terminate in round {round_index + 1}. Completed!')
                    end_time = time.time()
                    execution_time = end_time - start_time
                    execution_time_total += execution_time
                    with open(save_code_dir + f"/execution_time_{round_index + 1}.txt", "w") as f:
                        f.write(str(execution_time))
                    break
                elif os.path.exists(save_code_dir + f"/code_{round_index + 1}_0.py"):
                    with_code = True
                    try:
                        result = subprocess.run(
                            ["python3", save_code_dir + f"/code_{round_index + 1}_0.py"],
                            capture_output=True, text=True, timeout=10
                        )
                        output = result.stdout
                        errors = result.stderr
                    except subprocess.TimeoutExpired as e:
                        output = e.stdout if e.stdout else ""
                        errors = e.stderr if e.stderr else ""
                        errors += f"\nTimeoutExpired: Command '{e.cmd}' timed out after {e.timeout} seconds"

                    multi_turn_question = multi_turn_planning_prompt_with_code + f'The execution result from the code is:\noutput: {output}, errors: {errors}'
                    user_prompt_list.append(multi_turn_question)
                    response_total_list.append(response_code)
                    end_time = time.time()
                    execution_time = end_time - start_time
                    execution_time_total += execution_time
                    with open(save_code_dir + f"/execution_time_{round_index + 1}.txt", "w") as f:
                        f.write(str(execution_time))
                else:
                    #print(f'No code generated in round {round_index + 1}. Completed!')
                    multi_turn_question = multi_turn_planning_prompt_without_code
                    user_prompt_list.append(multi_turn_question)
                    response_total_list.append(response_code)

                    end_time = time.time()
                    execution_time = end_time - start_time
                    execution_time_total += execution_time
                    with open(save_code_dir + f"/execution_time_{round_index + 1}.txt", "w") as f:
                        f.write(str(execution_time))

            if with_code:
                num_with_code += 1
                time_with_code += execution_time_total
            else:
                num_without_code += 1
                time_without_code += execution_time_total

    print(f'ratio_with_code: {num_with_code/total_test_num}, ratio_without_code: {num_without_code/total_test_num}')
    if num_with_code != 0:
        print(f'average_time_with_code: {time_with_code/num_with_code}')
        with open(base_save_code_dir + f"/average_time_with_code.txt", "w") as f:
            f.write(str(time_with_code / num_with_code))
    if num_without_code != 0:
        print(f'average_time_without_code: {time_without_code/num_without_code}')
        with open(base_save_code_dir + f"/average_time_without_code.txt", "w") as f:
            f.write(str(time_without_code / num_without_code))

    print(f'Model_name: {model_name}, AutoGen_prompt_system_message: {AutoGen_prompt_system_message}, '
          f'AutoGen_prompt_concatenate: {AutoGen_prompt_concatenate}, code_interpreter: {code_interpreter}, Encourage_code_execution_interpreter: {Encourage_code_execution_interpreter}, '
          f'all_code_with_COT: {all_code_with_COT}, all_code_without_COT: {all_code_without_COT}, all_text: {all_text}, multi_turn_planning: {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}, '
          f'method_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n')
    print('*' * 30)

if __name__ == '__main__':
    # gpt-4o, gpt-4o-mini, gpt-3.5-turbo for OpenAi API
    # gpt-4o, gpt-35-turbo for Azure API
    # multi_turn_planning_round_num = [1, 2, 4, 8, 16]

    parser = ArgumentParser()
    parser.add_argument('-model_name', '--model_name', default='gpt-35-turbo-16k-0613')
    args = parser.parse_args()
    model_name = args.model_name

    dataset_input_dir = '../dataset_gather'
    save_input_dir = '../results_gather/path_plan'

    if not os.path.exists(save_input_dir):
        os.makedirs(save_input_dir)

    def log_run_info(log_file, run_info):
        with open(log_file, 'a') as f:
            f.write(run_info + "\n")

    # for multi_turn_planning_round_num in [1, 2, 4, 8, 16]:
    for multi_turn_planning_round_num in [1]:
        # for model_name in ['gpt-4o', 'gpt-4o-mini', 'gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
        # for model_name in ['gpt-35-turbo-16k-0613']:
        log_file = os.path.join(save_input_dir, f"run_log_{model_name}.txt")

        for dataset_input_dir, save_input_dir, model_name, code_interpreter, AutoGen_prompt_system_message, AutoGen_prompt_concatenate, \
            Encourage_code_execution_interpreter, all_code_with_COT, all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num, \
            method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first in [
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, True, False, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, True, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, True, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, True, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, True, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, True, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, False, True),
        ]:
            run_path_plan(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
                               AutoGen_prompt_concatenate, code_interpreter, Encourage_code_execution_interpreter,
                               all_code_with_COT,
                               all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num,
                               method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first)

            # Log the completed run
            run_info = f"Completed run: {model_name}, round_num={multi_turn_planning_round_num}, " \
                       f"{code_interpreter}, {AutoGen_prompt_system_message}, {AutoGen_prompt_concatenate}, " \
                       f"{Encourage_code_execution_interpreter}, {all_code_with_COT}, {all_code_without_COT}, {all_text}, {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}" \
                       f"\nmethod_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n"
            log_run_info(log_file, run_info)

        # for model_name in ['gpt-4o', 'gpt-4o-mini', 'gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
        # for model_name in ['gpt-4o']:
        log_file = os.path.join(save_input_dir, f"run_log_{model_name}.txt")

        for dataset_input_dir, save_input_dir, model_name, code_interpreter, AutoGen_prompt_system_message, AutoGen_prompt_concatenate, \
            Encourage_code_execution_interpreter, all_code_with_COT, all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num,\
                method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first in [
            (dataset_input_dir, save_input_dir, model_name, True, False, False, False, False, False, False, False, 1, False, False),
            (dataset_input_dir, save_input_dir, model_name, True, False, False, True, False, False, False, False, 1, False, False)
        ]:
            run_path_plan(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
                            AutoGen_prompt_concatenate, code_interpreter, Encourage_code_execution_interpreter,
                            all_code_with_COT,
                            all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num, method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first)

            # Log the completed run
            run_info = f"Completed run: {model_name}, round_num={multi_turn_planning_round_num}, " \
                       f"{code_interpreter}, {AutoGen_prompt_system_message}, {AutoGen_prompt_concatenate}, " \
                       f"{Encourage_code_execution_interpreter}, {all_code_with_COT}, {all_code_without_COT}, {all_text}, {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}" \
                       f"\nmethod_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n"
            log_run_info(log_file, run_info)