import os
from generation_models import message_construct_func, GPT_response, extract_and_check, extract_code
import re
import pandas as pd
import subprocess
from typing import List, Tuple, Dict
import time
import numpy as np
import ast
from run_BoxLift import verify_solution, estimate_steps, read_test_case
from argparse import ArgumentParser

def extract_equation_with_GPT4(response):
    prompt = 'Your task is to extract the final answer from the given answer by another LLM:\n' \
             'Note that the equation should be in the form like <<<answer>>>, <<<Step 1: [(185, [0, 1]), (108, [0, 1])]\nStep 2: [(184, [0, 1]), (75, [0, 1])]\nStep 3: [(174, [0, 1]), (70, [0, 1])]\nStep 4: [(171, [0, 1]), (63, [0]), (34, [0])]\nStep 5: [(157, [0, 1]), (32, [0]), (31, [0])]>>>, \n' \
             'Here is the reponse, return your answer with the format <<<equation>>>, like <<<Step 1: [(185, [0, 1]), (108, [0, 1])]\nStep 2: [(184, [0, 1]), (75, [0, 1])]>>>. ' \
             'Input text: ' \

    extract_equation = GPT_response('', prompt + response, model_name='gpt-4o', code_interpreter=False, user_prompt_list=[prompt + response], response_total_list=[])
    return extract_equation

#post_process_number_multiply
def post_process_boxlift(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
               AutoGen_prompt_concatenate, code_interpreter, Encourage_code_execution_interpreter, all_code_with_COT,
               all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num, method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first):
    print('\n' + '*'*30)
    print(f'Model_name: {model_name}, AutoGen_prompt_system_message: {AutoGen_prompt_system_message}, '
          f'AutoGen_prompt_concatenate: {AutoGen_prompt_concatenate}, code_interpreter: {code_interpreter}, Encourage_code_execution_interpreter: {Encourage_code_execution_interpreter}, '
          f'all_code_with_COT: {all_code_with_COT}, all_code_without_COT: {all_code_without_COT}, all_text: {all_text}, multi_turn_planning: {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}\n')

    total_sample_num = 0
    answer_with_code_wrong = 0
    answer_with_code_correct = 0
    answer_without_code_wrong = 0
    answer_without_code_correct = 0

    lifted_ratio_with_code = 0
    lifted_ratio_without_code = 0

    if method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == False:
        base_save_code_dir = save_input_dir + f'/result_boxlift_{model_name}_interpreter_{code_interpreter}_AutoGen_system_{AutoGen_prompt_system_message}_AutoGen_concatenate_{AutoGen_prompt_concatenate}_all_code_with_COT_{all_code_with_COT}_all_code_without_COT_{all_code_without_COT}_Encourage_code_execution_interpreter_{Encourage_code_execution_interpreter}_all_text_{all_text}_multi_turn_planning_{multi_turn_planning}_round_num_{multi_turn_planning_round_num}'
    elif method_9_all_text_all_code_summarizer == True and method_10_LLM_estimates_scores_first == False:
        base_save_code_dir = save_input_dir + f'/result_boxlift_{model_name}_method_9_all_text_all_code_summarizer'
    elif method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == True:
        base_save_code_dir = save_input_dir + f'/result_boxlift_{model_name}_method_10_LLM_estimates_scores_first'
    else:
        raise ValueError(
            "method_9_all_text_all_code_summarizer and method_10_LLM_estimates_scores_first can't be both True")

    if multi_turn_planning:
        round_number = multi_turn_planning_round_num
    else:
        round_number = 1

    lifted_box_ratio_list = []
    lifted_weight_ratio_list = []
    for num_boxes, num_lifters, min_box_weight, max_box_weight, min_lifter_capacity, max_lifter_capacity in \
            [(10, 3, 10, 100, 40, 80), (15, 4, 20, 200, 30, 120), (20, 5, 30, 300, 40, 160), (25, 6, 40, 400, 50, 200)]:
        for iteration_num in range(10):
            print(f'\n\nNum_boxes = {num_boxes}, Num_lifters = {num_lifters}, Iteration_num = {iteration_num}')
            save_code_dir = os.path.join(base_save_code_dir, f"{num_boxes}_{num_lifters}_{iteration_num}/")

            boxes, lifters = read_test_case(dataset_input_dir + f'/BoxLift_{num_boxes}_{num_lifters}/BoxLift{iteration_num}/BoxLift.json')
            print(f"Initial boxes: {boxes}")
            print(f"Initial lifters: {lifters}")

            estimated_steps = estimate_steps(boxes, lifters)
            print(f"Estimated number of steps: {estimated_steps}")

            with open(save_code_dir + "/response_code_1.txt", "r") as f:
                response = f.read()
            print(
                f'\nModel_name: {model_name}, AutoGen_prompt_system_message: {AutoGen_prompt_system_message}, AutoGen_prompt_concatenate: {AutoGen_prompt_concatenate}, code_interpreter: {code_interpreter}, Encourage_code_execution_interpreter: {Encourage_code_execution_interpreter}, all_code_with_COT: {all_code_with_COT}, all_code_without_COT: {all_code_without_COT}, all_text: {all_text}')

            itertools_present = 'code_interpreter' in response or '```python' in response

            code_block_list = extract_code(response)
            for index, code_string in enumerate(code_block_list):
                with open(save_code_dir + f"/code_1_{index}.py", "w") as f:
                    f.write(code_string)
                #print(f'code_{index}:\n {code_string}')

            # Test the generated code
            if not os.path.exists(save_code_dir + f"/code_1_0.py"):
                pass
            else:
                try:
                    result = subprocess.run(
                        ["python3", "-c", f"exec(open('{save_code_dir}/code_1_0.py').read()); print(result)"],
                        capture_output=True,
                        text=True,
                        timeout=15
                    )

                    response = result.stdout
                    errors = result.stderr
                except Exception as e:
                    print('Code execution error')
                    response = ""
                    errors = str(e)

            response_answer, _ = extract_and_check(response)
            print(f"Response: {response_answer}")

            if response_answer == '':
                response_answer = extract_equation_with_GPT4(response)

            is_correct, remaining, success_failure_list = verify_solution(boxes, lifters, response_answer, estimated_steps)

            print(f"Response: {response}")
            print(f"Response_answer: {response_answer}")
            print(f"Response is valid: {is_correct}")
            print(f'Initial boxes: {boxes}')
            print(f"Remaining boxes: {remaining}")
            print(f"Lifted box ratio: {(len(boxes) - len(remaining)) / len(boxes)}")
            print(f"Lifted weight ratio: {(sum(boxes) - sum(remaining)) / sum(boxes)}")
            lifted_box_ratio_list.append((len(boxes) - len(remaining)) / len(boxes))
            lifted_weight_ratio_list.append((sum(boxes) - sum(remaining)) / sum(boxes))

            with open(save_code_dir + "/Lifted_box_ratio_1.txt", "w") as f:
                f.write(str((len(boxes) - len(remaining)) / len(boxes)))
            with open(save_code_dir + "/Lifted_weight_ratio_1.txt", "w") as f:
                f.write(str((sum(boxes) - sum(remaining)) / sum(boxes)))
            with open(save_code_dir + "/response_answer.txt", "w") as f:
                f.write(response_answer)
            with open(save_code_dir + "/success_failure.txt", "w") as f:
                f.write(str(is_correct))

            if is_correct:
                print('True')
                #print(f'target_answer: {target_answer}')
                #print(f"response: {response}\n")
                if itertools_present == True:
                    answer_with_code_correct += 1
                elif itertools_present == False:
                    answer_without_code_correct += 1

            else:
                if itertools_present == True:
                    answer_with_code_wrong += 1
                elif itertools_present == False:
                    answer_without_code_wrong += 1
            if itertools_present == True:
                lifted_ratio_with_code += (len(boxes) - len(remaining)) / len(boxes)
            elif itertools_present == False:
                lifted_ratio_without_code += (len(boxes) - len(remaining)) / len(boxes)

    print(f'\ntotal_sample_num: {total_sample_num}')
    print(f'answer_with_code_wrong: {answer_with_code_wrong}')
    print(f'answer_without_code_wrong: {answer_without_code_wrong}')
    print(f'answer_with_code_correct: {answer_with_code_correct}')
    print(f'answer_without_code_correct: {answer_without_code_correct}')
    print(f'Total lifted weight ratio: {np.mean(lifted_weight_ratio_list)}')
    print(f'Total lifted box ratio: {np.mean(lifted_box_ratio_list)}')

    with open(base_save_code_dir + f"/answer_with_code_wrong.txt", "w") as f:
        f.write(str(answer_with_code_wrong))
    with open(base_save_code_dir + f"/answer_without_code_wrong.txt", "w") as f:
        f.write(str(answer_without_code_wrong))
    with open(base_save_code_dir + f"/answer_with_code_correct.txt", "w") as f:
        f.write(str(answer_with_code_correct))
    with open(base_save_code_dir + f"/answer_without_code_correct.txt", "w") as f:
        f.write(str(answer_without_code_correct))
    with open(base_save_code_dir + f"/total_lifted_weight_ratio.txt", "w") as f:
        f.write(str(np.mean(lifted_weight_ratio_list)))
    with open(base_save_code_dir + f"/total_lifted_box_ratio.txt", "w") as f:
        f.write(str(np.mean(lifted_box_ratio_list)))
    with open(base_save_code_dir + f"/lifted_weight_ratio_list.txt", "w") as f:
        f.write(str(lifted_weight_ratio_list))
    with open(base_save_code_dir + f"/lifted_box_ratio_list.txt", "w") as f:
        f.write(str(lifted_box_ratio_list))

    if answer_with_code_wrong + answer_with_code_correct > 0:
        print(f'with_code_lifted_ratio: {lifted_ratio_with_code / (answer_with_code_wrong + answer_with_code_correct)}')
        with open(base_save_code_dir + f"/with_code_lifted_ratio.txt", "w") as f:
            f.write(str(lifted_ratio_with_code / (answer_with_code_wrong + answer_with_code_correct)))
    if answer_without_code_wrong + answer_without_code_correct > 0:
        print(f'without_code_lifted_ratio: {lifted_ratio_without_code / (answer_without_code_wrong + answer_without_code_correct)}')
        with open(base_save_code_dir + f"/without_code_lifted_ratio.txt", "w") as f:
            f.write(str(lifted_ratio_without_code / (answer_without_code_wrong + answer_without_code_correct)))

    print(f'\nModel_name: {model_name}, AutoGen_prompt_system_message: {AutoGen_prompt_system_message}, AutoGen_prompt_concatenate: {AutoGen_prompt_concatenate}, code_interpreter: {code_interpreter}, Encourage_code_execution_interpreter: {Encourage_code_execution_interpreter}, all_code_with_COT: {all_code_with_COT}, all_code_without_COT: {all_code_without_COT}, all_text: {all_text}')
    print('*' * 30)

    run_info = f"{model_name}, round_num={multi_turn_planning_round_num}, " \
               f"{code_interpreter}, {AutoGen_prompt_system_message}, {AutoGen_prompt_concatenate}, " \
               f"{Encourage_code_execution_interpreter}, {all_code_with_COT}, {all_code_without_COT}, {all_text}, {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}" \
               f"\nmethod_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n"

    run_info_result = f'answer_with_code_wrong:{answer_with_code_wrong}, answer_without_code_wrong: {answer_without_code_wrong}, answer_with_code_correct: {answer_with_code_correct}, answer_without_code_correct: {answer_without_code_correct}, ' \
                      f'total_lifted_weight_ratio: {np.mean(lifted_weight_ratio_list)}, total_lifted_box_ratio: {np.mean(lifted_box_ratio_list)}\n'
    log_file_result = os.path.join(save_input_dir, f"acc_result_log_{model_name}.txt")
    log_run_info(log_file_result, run_info + run_info_result)

if __name__ == '__main__':
    # gpt-4o, gpt-4o-mini, gpt-3.5-turbo for OpenAi API
    # gpt-4o, gpt-35-turbo for Azure API
    # multi_turn_planning_round_num = [1, 2, 4, 8, 16]

    parser = ArgumentParser()
    parser.add_argument('-model_name', '--model_name', default='gpt-35-turbo-16k-0613')
    args = parser.parse_args()
    model_name = args.model_name

    dataset_input_dir = '../dataset_gather/BoxLift_dataset'
    save_input_dir = '../results_gather/BoxLift'

    def log_run_info(log_file, run_info):
        with open(log_file, 'a') as f:
            f.write(run_info + "\n")

    # for multi_turn_planning_round_num in [1, 2, 4, 8, 16]:
    for multi_turn_planning_round_num in [1]:
        # for model_name in ['gpt-4o', 'gpt-4o-mini', 'gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
        # for model_name in ['gpt-4o']:
        log_file = os.path.join(save_input_dir, f"run_log_{model_name}.txt")

        for dataset_input_dir, save_input_dir, model_name, code_interpreter, AutoGen_prompt_system_message, AutoGen_prompt_concatenate, \
            Encourage_code_execution_interpreter, all_code_with_COT, all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num \
                , method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first in [
            #(dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            #(dataset_input_dir, save_input_dir, model_name, False, True, False, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            #(dataset_input_dir, save_input_dir, model_name, False, False, True, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            #(dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, True, True, multi_turn_planning_round_num, False, False),
            #(dataset_input_dir, save_input_dir, model_name, False, False, False, False, True, False, False, True, multi_turn_planning_round_num, False, False),
            #(dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, True, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, True, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, False, True),
        ]:
            post_process_boxlift(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
                                 AutoGen_prompt_concatenate, code_interpreter, Encourage_code_execution_interpreter,
                                 all_code_with_COT,
                                 all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num,
                                 method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first)

            # Log the completed run
            run_info = f"Completed run: {model_name}, round_num={multi_turn_planning_round_num}, " \
                       f"{code_interpreter}, {AutoGen_prompt_system_message}, {AutoGen_prompt_concatenate}, " \
                       f"{Encourage_code_execution_interpreter}, {all_code_with_COT}, {all_code_without_COT}, {all_text}, {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}" \
                       f"\nmethod_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n"
            log_run_info(log_file, run_info)


'''
    #for model_name in ['gpt-4o', 'gpt-4o-mini', 'gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
    #for model_name in ['gpt-4o']:
    log_file = os.path.join(save_input_dir, f"run_log_{model_name}.txt")

    for dataset_input_dir, save_input_dir, model_name, code_interpreter, AutoGen_prompt_system_message, AutoGen_prompt_concatenate, \
        Encourage_code_execution_interpreter, all_code_with_COT, all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num\
        ,method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first in [
        (dataset_input_dir, save_input_dir, model_name, True, False, False, False, False, False, False, False, 1, False, False),
        (dataset_input_dir, save_input_dir, model_name, True, False, False, True, False, False, False, False, 1, False, False)
    ]:
        post_process_boxlift(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
                      AutoGen_prompt_concatenate, code_interpreter, Encourage_code_execution_interpreter,
                      all_code_with_COT,
                      all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num, method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first)

        # Log the completed run
        run_info = f"Completed run: {model_name}, round_num={multi_turn_planning_round_num}, " \
                   f"{code_interpreter}, {AutoGen_prompt_system_message}, {AutoGen_prompt_concatenate}, " \
                   f"{Encourage_code_execution_interpreter}, {all_code_with_COT}, {all_code_without_COT}, {all_text}, {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}" \
                   f"\nmethod_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n"
        log_run_info(log_file, run_info)
'''
