import os
from generation_models import message_construct_func, GPT_response, extract_and_check, extract_code
import re
import pandas as pd
import subprocess
import time
from post_process_path_plan_continuous_func import check_trajectory
import time
from argparse import ArgumentParser

def True_false_func(box_dict, starting_position, ending_position, extracted_waypoint_list_code, index):
    if extracted_waypoint_list_code == '':
        extracted_waypoint_list_code = '[]'
    try:
        waypoints = eval(extracted_waypoint_list_code)
    except:
        waypoints = []
        print('Wrong format of waypoints: ', extracted_waypoint_list_code)

    if waypoints == []:
        print('Extracted_waypoint_list_code: ', extracted_waypoint_list_code)

    try:
        True_false_result, feedback_reason = check_trajectory(box_dict, starting_position, ending_position, waypoints,
                                                                index)
    except:
        True_false_result = False
        print('Error in trajectory checking')
    return True_false_result


def extract_code(text):
    # Regular expression to match code blocks enclosed in triple backticks
    code_block_pattern = re.compile(r'```python\n(.*?)\n```', re.DOTALL)

    # Find all matches in the text
    code_blocks = code_block_pattern.findall(text)

    # If no code blocks are found, try to find indented code blocks
    if not code_blocks:
        return []

    return code_blocks

def extract_equation_with_GPT4(response):
    prompt = 'Your task is to extract the waypoints of the robot trajectory from the given answer by another LLM:\n' \
             'Note that the waypoints should include a list of (x, y) coordinates like [(-1.3, -1.3), (-0.85, 0.125), (-0.75, -1.1), (0.45, -0.75), (0.45, 1.0), (1.3, 1.3)], ' \
             '[(1.3, -1.3), (0.45, 1.0), (0.45, -1.0), (-0.85, 0.1), (1.3, 1.3)] \n' \
             'Here is the response, return your answer with the format <<<list>>>, like <<<[(1.3, -1.3), (0.65, 0.9), (0.45, 0.0), (1.3, 1.3)]>>>.\n' \
             'If the input text does not have <<<>>> and is already the pure answer, add <<<>>> and return your answer.\n' \
             'Note that if you find no waypoints are answered, then directly answer empty list <<<[]>>>.\n' \
             'Input text: ' \

    extract_equation = GPT_response('', prompt + response, model_name='gpt-4o', code_interpreter=False, user_prompt_list = [prompt + response], response_total_list = [])
    return extract_equation

def extract_and_check(response):
    # Extract all texts between <<< and >>>
    matches = re.findall(r'<<<(.*?)>>>', response)
    extracted_text = matches[-1].strip() if matches else ''

    # Check if 'itertools' appears in the response
    itertools_present = 'code_interpreter' in response or '```python' in response

    return extracted_text, itertools_present

#post_process_path_plan
def post_process_path_plan(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
               AutoGen_prompt_concatenate, code_interpreter, Encourage_code_execution_interpreter, all_code_with_COT,
               all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num, method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first):
    print('\n' + '*'*30)
    print(f'Model_name: {model_name}, AutoGen_prompt_system_message: {AutoGen_prompt_system_message}, '
          f'AutoGen_prompt_concatenate: {AutoGen_prompt_concatenate}, code_interpreter: {code_interpreter}, Encourage_code_execution_interpreter: {Encourage_code_execution_interpreter}, '
          f'all_code_with_COT: {all_code_with_COT}, all_code_without_COT: {all_code_without_COT}, all_text: {all_text}, multi_turn_planning: {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}\n')
    walls = [(-1.5, -1.4, -1.5, 1.5), (1.4, 1.5, -1.5, 1.5), (-1.5, 1.5, -1.5, -1.4), (-1.5, 1.5, 1.4, 1.5)]

    # First Environment
    box_dict_1 = {'yellow': (-1, -0.7, -0.25, 0.5), 'red': (0, 0.9, -1, -0.5), 'green': (0.2, 0.7, 0.8, 1.2),
                'blue': (-0.5, 0.5, -0.5, 0.5), 'pink': (-1.2, 0.0, 0.6, 0.9), 'purple': (-1.0, -0.5, -1.3, -0.9), 'orange': (0.6, 1.2, -0.5, 0.5)}
    starting_position_1 = (-1.3, -1.3); ending_position_1 = (1.3, 1.3)
    Instruction_simple_houseworld_1_list = \
        ['Navigate into the green room and then go to the yellow room. Should be in order.',
        'Navigate into the yellow room, then go to the purple room, and then to the red room, and then to the green room. The places should be visited in order.',
        'Navigate into the yellow room, then go to the purple room, and then to the red room, and then to the green room. The places should be visited in order. Remember do not enter the blue area all the time.',
        'Navigate into the green room and then go to the yellow room, the places should be visited in order.',
        'Visit blue region during your trajectory, but never enter all the other colored boxes.',
        'Navigate into the green room and then go to the yellow room, the places should be visited in order. Remember do not enter the pink area all the time.',
        'Navigate into the yellow room and then go to the orange room, the places should be visited in order. Remember do not enter the blue, purple, and red areas all the time.',
        'Navigate into the green room and then go to the yellow room and then go to the red room, the places should be visited in order. Remember do not enter the blue area all the time.',
        'Visit purple, orange, and pink areas in order, but remember never enter all the other colored areas.',
        'At some point go to the yellow box, and then at some point go to the red box, and then enter the green box, and always do not enter the blue area. The places should be visited in order.']

    # Second Environment
    box_dict_2 = box_dict_1; starting_position_2 = (1.3, -1.3); ending_position_2 = (1.3, 1.3); Instruction_simple_houseworld_2_list = Instruction_simple_houseworld_1_list

    # Third Environment
    box_dict_3 = {'yellow': (-1, -0.7, -0.25, 0.5), 'red': (0, 0.9, -1, -0.5), 'green': (0.2, 0.7, 0.8, 1.2),
                'blue': (-0.2, 0.2, -0.2, 0.2), 'pink': (-1.2, 0.0, 0.6, 0.9), 'purple': (-1.0, -0.5, -1.3, -0.9), 'orange': (0.6, 1.2, -0.5, 0.5)}
    starting_position_3 = starting_position_1; ending_position_3 = ending_position_1; Instruction_simple_houseworld_3_list = Instruction_simple_houseworld_1_list

    # Forth Environment
    box_dict_4 = box_dict_1; starting_position_4 = (-1.3, 1.3); ending_position_4 = (1.3, 1.3); Instruction_simple_houseworld_4_list = Instruction_simple_houseworld_1_list

    # Fifth Environment
    box_dict_5 = {'red': (-1, -0.7, -0.25, 0.5), 'yellow': (0, 0.9, -1.3, -0.8), 'green': (0.2, 0.7, 0.8, 1.2),
                'blue': (-0.3, 0.3, -0.3, 0.3), 'orange': (-1.2, 0.0, 0.6, 0.9), 'purple': (-1.0, -0.5, -1.3, -0.7), 'pink': (0.6, 1.2, -0.5, 0.5)}
    starting_position_5 = (1.3, -1.3); ending_position_5 = (1.3, 1.3); Instruction_simple_houseworld_5_list = Instruction_simple_houseworld_1_list

    # Sixth Environment
    box_dict_6 = {'red': (-1, -0.7, -0.25, 0.5), 'yellow': (0, 0.9, -1.3, -0.6), 'green': (0.1, 0.9, 0.7, 1.4),
                'blue': (-0.3, 0.3, -0.3, 0.3), 'orange': (-1.2, 0.0, 0.6, 0.9), 'purple': (-1.0, -0.25, -1.3, -0.5),
                'pink': (0.6, 1.2, -0.5, 0.5)}
    starting_position_6 = (1.3, -1.3); ending_position_6 = (1.3, 1.3); Instruction_simple_houseworld_6_list = Instruction_simple_houseworld_1_list

    # Seventh Environment
    box_dict_7 = {'pink': (-1, -0.7, -0.25, 0.5), 'purple': (0, 0.9, -1.3, -0.6), 'green': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.3, 0.3, -0.3, 0.3), 'orange': (-1.2, 0.0, 0.6, 1.4), 'yellow': (-1.0, -0.25, -1.3, -0.5),
                'red': (0.6, 1.2, -0.5, 0.5)}
    starting_position_7 = (1.1, 1.3); ending_position_7 = (-1.3, 1.1); Instruction_simple_houseworld_7_list = Instruction_simple_houseworld_1_list

    # Eighth Environment
    box_dict_8 = {'pink': (-1.3, -0.9, -0.25, 0.5), 'purple': (0, 0.9, -1.3, -0.7), 'green': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.55, 0.55, -0.55, 0.55), 'orange': (-1.2, 0.0, 0.7, 1.3),
                'yellow': (-1.0, -0.25, -1.3, -0.7), 'red': (0.7, 1.2, -0.5, 0.5)}
    starting_position_8 = (1.3, 1.3); ending_position_8 = (-1.3, -1.3); Instruction_simple_houseworld_8_list = Instruction_simple_houseworld_1_list

    # Ninth Environment
    box_dict_9 = {'pink': (-1.3, -0.9, -0.25, 0.5), 'purple': (-0.3, 0.6, -1.3, -0.7), 'green': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.55, 1.4, -0.3, 0.5), 'orange': (-1.2, 0.0, 0.7, 1.3), 'yellow': (-1.3, -0.4, -1.3, -0.7),
                'red': (0.7, 1.2, -1.2, -0.5)}
    starting_position_9 = (1.35, 1.35); ending_position_9 = (-1.35, -1.35); Instruction_simple_houseworld_9_list = Instruction_simple_houseworld_1_list

    # Tenth Environment
    box_dict_10 = {'pink': (-1.3, -0.9, -0.25, 0.5), 'purple': (-0.3, 0.6, -1.3, -0.7), 'green': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.55, 1.4, -0.3, 0.5), 'orange': (-1.2, 0.0, 0.7, 1.3), 'yellow': (-1.3, -0.4, -1.3, -0.7),
                'red': (0.7, 1.2, -1.2, -0.5)}
    starting_position_10 = (-1.35, 1.35); ending_position_10 = (1.35, -1.35); Instruction_simple_houseworld_10_list = Instruction_simple_houseworld_1_list

    # Eleventh Environment
    box_dict_11 = {'green': (-1.3, -0.8, -0.25, 0.5), 'purple': (-0.3, 0.6, -1.1, -0.5), 'pink': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.55, 1.4, -0.3, 0.5), 'orange': (-1.2, 0.0, 0.7, 1.3), 'yellow': (-1.3, -0.4, -1.1, -0.5),
                'red': (0.7, 1.2, -1.2, -0.7)}
    starting_position_11 = (1.35, -1.35); ending_position_11 = (-1.35, 1.35); Instruction_simple_houseworld_11_list = Instruction_simple_houseworld_1_list

    # Twelfth Environment
    box_dict_12 = {'green': (-1.3, -0.8, -0.25, 0.5), 'purple': (-0.3, 0.6, -1.1, -0.5), 'pink': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.55, 1.4, -0.3, 0.5), 'orange': (-1.2, 0.0, 0.7, 1.3), 'yellow': (-1.3, -0.4, -1.1, -0.5),
                'red': (0.7, 1.2, -1.2, -0.7)}
    starting_position_12 = (1.2, 0.9); ending_position_12 = (-1.35, -1.35); Instruction_simple_houseworld_12_list = Instruction_simple_houseworld_1_list

    # Thirteenth Environment
    box_dict_13 = {'green': (-1.3, -0.8, -0.25, 0.5), 'purple': (-0.3, 0.6, -1.1, -0.5), 'pink': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.55, 1.4, -0.3, 0.5), 'orange': (-1.2, 0.0, 0.7, 1.3), 'yellow': (-1.3, -0.4, -1.1, -0.5),
                'red': (0.7, 1.2, -1.2, -0.7)}
    starting_position_13 = (-0.7, 0.0); ending_position_13 = (1.3, -0.5); Instruction_simple_houseworld_13_list = Instruction_simple_houseworld_1_list

    # Fourteenth Environment
    box_dict_14 = {'pink': (-1.3, -0.9, -0.25, 0.5), 'purple': (0, 0.9, -1.3, -0.7), 'green': (0.1, 0.9, 0.7, 1.2),
                'blue': (-0.55, 0.55, -0.55, 0.55), 'orange': (-1.2, 0.0, 0.7, 1.3),
                'yellow': (-1.0, -0.25, -1.3, -0.7), 'red': (0.7, 1.2, -0.5, 0.5)}
    starting_position_14 = (-0.7, 0.0); ending_position_14 = (-1.3, -1.3); Instruction_simple_houseworld_14_list = Instruction_simple_houseworld_1_list

    box_dict_list = [box_dict_1, box_dict_2, box_dict_3, box_dict_4, box_dict_5, box_dict_6, box_dict_7, box_dict_8, box_dict_9, box_dict_10, box_dict_11, box_dict_12, box_dict_13, box_dict_14]
    starting_position_list = [starting_position_1, starting_position_2, starting_position_3, starting_position_4, starting_position_5, starting_position_6, starting_position_7, starting_position_8, starting_position_9, starting_position_10, starting_position_11, starting_position_12, starting_position_13, starting_position_14]
    ending_position_list = [ending_position_1, ending_position_2, ending_position_3, ending_position_4, ending_position_5, ending_position_6, ending_position_7, ending_position_8, ending_position_9, ending_position_10, ending_position_11, ending_position_12, ending_position_13, ending_position_14]
    Instruction_simple_houseworld_list_gather = [Instruction_simple_houseworld_1_list, Instruction_simple_houseworld_2_list, Instruction_simple_houseworld_3_list,
                                                 Instruction_simple_houseworld_4_list, Instruction_simple_houseworld_5_list, Instruction_simple_houseworld_6_list,
                                                 Instruction_simple_houseworld_7_list, Instruction_simple_houseworld_8_list, Instruction_simple_houseworld_9_list,
                                                 Instruction_simple_houseworld_10_list, Instruction_simple_houseworld_11_list, Instruction_simple_houseworld_12_list,
                                                 Instruction_simple_houseworld_13_list, Instruction_simple_houseworld_14_list]

    if method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == False:
        base_save_code_dir = save_input_dir + f'/result_path_plan_{model_name}_interpreter_{code_interpreter}_AutoGen_system_{AutoGen_prompt_system_message}_AutoGen_concatenate_{AutoGen_prompt_concatenate}_all_code_with_COT_{all_code_with_COT}_all_code_without_COT_{all_code_without_COT}_Encourage_code_execution_interpreter_{Encourage_code_execution_interpreter}_all_text_{all_text}_multi_turn_planning_{multi_turn_planning}_round_num_{multi_turn_planning_round_num}'
    elif method_9_all_text_all_code_summarizer == True and method_10_LLM_estimates_scores_first == False:
        base_save_code_dir = save_input_dir + f'/result_path_plan_{model_name}_method_9_all_text_all_code_summarizer'
    elif method_9_all_text_all_code_summarizer == False and method_10_LLM_estimates_scores_first == True:
        base_save_code_dir = save_input_dir + f'/result_path_plan_{model_name}_method_10_LLM_estimates_scores_first'
    else:
        raise ValueError("method_9_all_text_all_code_summarizer and method_10_LLM_estimates_scores_first can't be both True")


    total_sample_num = 0
    answer_with_code_wrong = 0
    answer_with_code_correct = 0
    answer_without_code_wrong = 0
    answer_without_code_correct = 0

    if multi_turn_planning:
        round_number = multi_turn_planning_round_num
    else:
        round_number = 1

    for env_index in range(14):
        box_dict = box_dict_list[env_index];
        starting_position = starting_position_list[env_index];
        ending_position = ending_position_list[env_index]
        Instruction_simple_houseworld_list = Instruction_simple_houseworld_list_gather[env_index]
        for index in range(len(Instruction_simple_houseworld_list)):
            total_sample_num += 1
            save_code_dir = os.path.join(base_save_code_dir, f'sample_{env_index}_{index}')
            with open(save_code_dir + "/response_code_1.txt", "r") as f:
                response = f.read()
            original_response = response
            # print(f'Original_response: {original_response}')

            itertools_present = 'code_interpreter' in response or '```python' in response
            print(f'\nSample_{env_index}_{index}, model_name_{model_name}:')
            print(
                f'\nModel_name: {model_name}, AutoGen_prompt_system_message: {AutoGen_prompt_system_message}, AutoGen_prompt_concatenate: {AutoGen_prompt_concatenate}, code_interpreter: {code_interpreter}, Encourage_code_execution_interpreter: {Encourage_code_execution_interpreter}, all_code_with_COT: {all_code_with_COT}, all_code_without_COT: {all_code_without_COT}, all_text: {all_text}')

            code_block_list = extract_code(response)
            for index, code_string in enumerate(code_block_list):
                with open(save_code_dir + f"/code_1_{index}.py", "w") as f:
                    f.write(code_string)

            # Test the generated code
            if not os.path.exists(save_code_dir + f"/code_1_0.py"):
                pass
            else:
                try:
                    result = subprocess.run(["python3", "-c", f"exec(open('{save_code_dir}/code_1_0.py').read()); print(result)"], capture_output=True, text=True, timeout=15)
                    if result.stdout == '':
                        result = subprocess.run(
                            ["python3", "-c", f"exec(open('{save_code_dir}/code_1_0.py').read()); print(Waypoints)"],
                            capture_output=True, text=True, timeout=15)
                    if result.stdout == '':
                        result = subprocess.run(
                            ["python3", "-c", f"exec(open('{save_code_dir}/code_1_0.py').read()); print(waypoints)"],
                            capture_output=True, text=True, timeout=15)
                    if result.stdout == '':
                        result = subprocess.run(
                            ["python3", "-c", f"exec(open('{save_code_dir}/code_1_0.py').read()); print(trajectory)"],
                            capture_output=True, text=True, timeout=15)

                    response = result.stdout
                    errors = result.stderr
                except Exception as e:
                    pass

            output_1 = None;
            iteration_num_1 = 0
            while output_1 == None and iteration_num_1 < 3:
                iteration_num_1 += 1
                output_1 = extract_equation_with_GPT4(response)
            extracted_text_1, _ = extract_and_check(output_1)

            output_2 = None;
            iteration_num_2 = 0
            while output_2 == None and iteration_num_2 < 3:
                iteration_num_2 += 1
                output_2 = extract_equation_with_GPT4(original_response)
            extracted_text_2, _ = extract_and_check(output_2)

            True_false_result_1 = True_false_func(box_dict, starting_position, ending_position, extracted_text_1, index)
            True_false_result_2 = True_false_func(box_dict, starting_position, ending_position, extracted_text_2, index)

            if original_response != response:
                print(f'New response: {response}')

            print(f'True_false_result from response: {True_false_result_1}')
            print(f'True_false_result from original_response: {True_false_result_2}')
            #print(f'target_answer: {target_answer}')
            print(f'extracted_text from response: {extracted_text_1}')
            print(f'extracted_text from original_response: {extracted_text_2}')
            with open(save_code_dir + f"/True_false_result_1.txt", "w") as f:
                f.write(str(True_false_result_1))
            with open(save_code_dir + f"/True_false_result_2.txt", "w") as f:
                f.write(str(True_false_result_2))
            with open(save_code_dir + f"/extracted_answer_1.txt", "w") as f:
                f.write(extracted_text_1)
            with open(save_code_dir + f"/extracted_answer_2.txt", "w") as f:
                f.write(extracted_text_2)
            with open(save_code_dir + f"/output_response.txt", "w") as f:
                f.write(output_1)
            with open(save_code_dir + f"/output_original_response.txt", "w") as f:
                f.write(output_2)


            if True_false_result_1 == False and True_false_result_2 == False:
                print('False')
                if itertools_present == True:
                    answer_with_code_wrong += 1
                elif itertools_present == False:
                    answer_without_code_wrong += 1
            elif True_false_result_1 == True or True_false_result_2 == True:
                print('True')
                if itertools_present == True:
                    answer_with_code_correct += 1
                elif itertools_present == False:
                    answer_without_code_correct += 1
            else:
                raise ValueError('Error')

    print(f'\ntotal_sample_num: {total_sample_num}')
    print(f'answer_with_code_wrong: {answer_with_code_wrong}')
    print(f'answer_without_code_wrong: {answer_without_code_wrong}')
    print(f'answer_with_code_correct: {answer_with_code_correct}')
    print(f'answer_without_code_correct: {answer_without_code_correct}')

    with open(base_save_code_dir + f"/answer_with_code_wrong.txt", "w") as f:
        f.write(str(answer_with_code_wrong))
    with open(base_save_code_dir + f"/answer_without_code_wrong.txt", "w") as f:
        f.write(str(answer_without_code_wrong))
    with open(base_save_code_dir + f"/answer_with_code_correct.txt", "w") as f:
        f.write(str(answer_with_code_correct))
    with open(base_save_code_dir + f"/answer_without_code_correct.txt", "w") as f:
        f.write(str(answer_without_code_correct))

    print(f'\nModel_name: {model_name}, AutoGen_prompt_system_message: {AutoGen_prompt_system_message}, AutoGen_prompt_concatenate: {AutoGen_prompt_concatenate}, code_interpreter: {code_interpreter}, Encourage_code_execution_interpreter: {Encourage_code_execution_interpreter}, all_code_with_COT: {all_code_with_COT}, all_code_without_COT: {all_code_without_COT}, all_text: {all_text}')
    print('*' * 30)

    run_info = f"{model_name}, round_num={multi_turn_planning_round_num}, " \
               f"{code_interpreter}, {AutoGen_prompt_system_message}, {AutoGen_prompt_concatenate}, " \
               f"{Encourage_code_execution_interpreter}, {all_code_with_COT}, {all_code_without_COT}, {all_text}, {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}" \
               f"\nmethod_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n"
    run_info_result = f'answer_with_code_wrong:{answer_with_code_wrong}, answer_without_code_wrong: {answer_without_code_wrong}, answer_with_code_correct: {answer_with_code_correct}, answer_without_code_correct: {answer_without_code_correct}\n'
    log_file_result = os.path.join(save_input_dir, f"acc_result_log_{model_name}.txt")
    log_run_info(log_file_result, run_info + run_info_result)

if __name__ == '__main__':
    # gpt-4o, gpt-4o-mini, gpt-3.5-turbo for OpenAi API
    # gpt-4o, gpt-35-turbo for Azure API
    # multi_turn_planning_round_num = [1, 2, 4, 8, 16]

    parser = ArgumentParser()
    parser.add_argument('-model_name', '--model_name', default='gpt-35-turbo-16k-0613')
    args = parser.parse_args()
    model_name = args.model_name

    dataset_input_dir = '../dataset_gather'
    save_input_dir = '../results_gather/path_plan'

    def log_run_info(log_file, run_info):
        with open(log_file, 'a') as f:
            f.write(run_info + "\n")

    # for multi_turn_planning_round_num in [1, 2, 4, 8, 16]:
    for multi_turn_planning_round_num in [1]:
        # for model_name in ['gpt-4o', 'gpt-4o-mini', 'gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
        # for model_name in ['gpt-4o']:
        log_file = os.path.join(save_input_dir, f"run_log_{model_name}.txt")

        for dataset_input_dir, save_input_dir, model_name, code_interpreter, AutoGen_prompt_system_message, AutoGen_prompt_concatenate, \
            Encourage_code_execution_interpreter, all_code_with_COT, all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num \
                , method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first in [
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, True, False, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, True, False, False, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, True, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, True, False, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, True, False, True, multi_turn_planning_round_num, False, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, True, False),
            (dataset_input_dir, save_input_dir, model_name, False, False, False, False, False, False, False, True, multi_turn_planning_round_num, False, True),
        ]:
            post_process_path_plan(dataset_input_dir, save_input_dir, model_name,
                                        AutoGen_prompt_system_message,
                                        AutoGen_prompt_concatenate, code_interpreter,
                                        Encourage_code_execution_interpreter, all_code_with_COT,
                                        all_code_without_COT, all_text, multi_turn_planning,
                                        multi_turn_planning_round_num, method_9_all_text_all_code_summarizer,
                                        method_10_LLM_estimates_scores_first)

            # Log the completed run
            run_info = f"Completed run: {model_name}, round_num={multi_turn_planning_round_num}, " \
                       f"{code_interpreter}, {AutoGen_prompt_system_message}, {AutoGen_prompt_concatenate}, " \
                       f"{Encourage_code_execution_interpreter}, {all_code_with_COT}, {all_code_without_COT}, {all_text}, {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}" \
                       f"\nmethod_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n"
            log_run_info(log_file, run_info)

    #for model_name in ['gpt-4o', 'gpt-4o-mini', 'gpt-3.5-turbo', 'gpt-35-turbo-16k-0613']:
    #for model_name in ['gpt-4o']:
    log_file = os.path.join(save_input_dir, f"run_log_{model_name}.txt")

    for dataset_input_dir, save_input_dir, model_name, code_interpreter, AutoGen_prompt_system_message, AutoGen_prompt_concatenate, \
        Encourage_code_execution_interpreter, all_code_with_COT, all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num\
            , method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first in [
        (dataset_input_dir, save_input_dir, model_name, True, False, False, False, False, False, False, False, 1, False, False),
        (dataset_input_dir, save_input_dir, model_name, True, False, False, True, False, False, False, False, 1, False, False)
    ]:
        post_process_path_plan(dataset_input_dir, save_input_dir, model_name, AutoGen_prompt_system_message,
                      AutoGen_prompt_concatenate, code_interpreter, Encourage_code_execution_interpreter,
                      all_code_with_COT,
                      all_code_without_COT, all_text, multi_turn_planning, multi_turn_planning_round_num, method_9_all_text_all_code_summarizer, method_10_LLM_estimates_scores_first)

        # Log the completed run
        run_info = f"Completed run: {model_name}, round_num={multi_turn_planning_round_num}, " \
                   f"{code_interpreter}, {AutoGen_prompt_system_message}, {AutoGen_prompt_concatenate}, " \
                   f"{Encourage_code_execution_interpreter}, {all_code_with_COT}, {all_code_without_COT}, {all_text}, {multi_turn_planning}, multi_turn_planning_round_num: {multi_turn_planning_round_num}" \
                   f"\nmethod_9_{method_9_all_text_all_code_summarizer}, method_10_{method_10_LLM_estimates_scores_first}\n"
        log_run_info(log_file, run_info)